/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.security;

import io.quarkiverse.renarde.configuration.RenardeConfig;
import io.quarkiverse.renarde.impl.RenardeConfigBean;
import io.quarkiverse.renarde.security.RenardeTenantProvider;
import io.quarkiverse.renarde.security.RenardeUser;
import io.quarkiverse.renarde.security.RenardeUserProvider;
import io.quarkiverse.renarde.util.Flash;
import io.quarkiverse.renarde.util.RedirectException;
import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.jwt.build.Jwt;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;

@ApplicationScoped
public class RenardeSecurity {
    private static final Logger log = Logger.getLogger(RenardeSecurity.class);
    @ConfigProperty(name="mp.jwt.verify.issuer")
    String jwtIssuer;
    @ConfigProperty(name="mp.jwt.token.cookie")
    String jwtCookie;
    @ConfigProperty(name="quarkus.oidc.authentication.cookie-suffix", defaultValue="q_session")
    String oidcCookie;
    @ConfigProperty(name="quarkus.renarde.auth.location-cookie")
    String locationCookie;
    @Inject
    HttpServerRequest request;
    @Inject
    HttpServerResponse response;
    @Inject
    RenardeConfigBean config;
    @Inject
    SecurityIdentity identity;
    @Inject
    RenardeTenantProvider tenantProvider;
    @Inject
    RenardeUserProvider userProvider;
    @Inject
    RenardeConfig renardeConfig;
    @Inject
    HttpHeaders headers;
    @Inject
    Flash flash;

    public NewCookie makeUserCookie(RenardeUser user) {
        Set<String> roles = user.roles();
        String token = Jwt.issuer((String)this.jwtIssuer).upn(user.userId()).groups(roles).expiresIn(Duration.ofDays(10L)).innerSign().encrypt();
        return ((NewCookie.Builder)((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(this.jwtCookie).value(token)).path("/")).sameSite(NewCookie.SameSite.LAX)).httpOnly(true)).build();
    }

    public RenardeUser getUser() {
        if (!this.identity.isAnonymous()) {
            RenardeUser user;
            String authId = RenardeSecurity.getUserId(this.identity.getPrincipal());
            String tenantId = this.tenantProvider.getTenantId();
            if (tenantId == null) {
                tenantId = "manual";
            }
            if ((user = this.userProvider.findUser(tenantId, authId)) == null) {
                this.redirectToLogin("Invalid user: " + authId);
            }
            if (!user.registered()) {
                return null;
            }
            return user;
        }
        return null;
    }

    public static String getUserId(Principal principal) {
        if (principal instanceof JsonWebToken) {
            JsonWebToken idToken = (JsonWebToken)principal;
            String authId = (String)idToken.getClaim(Claims.upn.name());
            if (authId == null) {
                authId = (String)idToken.getClaim(Claims.sub.name());
            }
            return authId;
        }
        return principal.getName();
    }

    public Response makeLogoutResponse() {
        try {
            return this.makeLogoutResponse(new URI("/"));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Response makeLogoutResponse(URI redirectUri) {
        return Response.seeOther((URI)redirectUri).cookie(this.makeLogoutCookies()).build();
    }

    public NewCookie[] makeLogoutCookies() {
        Set<String> tenants = this.tenantProvider.getTenants();
        ArrayList<NewCookie> cookies = new ArrayList<NewCookie>(tenants.size() + 1);
        cookies.add(this.invalidateCookie(this.oidcCookie));
        for (String tenant : tenants) {
            cookies.add(this.invalidateCookie(this.oidcCookie + "_" + tenant));
        }
        cookies.add(this.invalidateCookie(this.jwtCookie));
        return cookies.toArray(new NewCookie[0]);
    }

    public Response makeRedirectAfterLogin(URI uri) {
        Map cookies = this.headers.getCookies();
        Cookie redirectCookie = (Cookie)cookies.get(this.renardeConfig.auth.locationCookie);
        NewCookie newCookie = null;
        if (redirectCookie != null) {
            String value = redirectCookie.getValue();
            newCookie = this.invalidateCookie(this.renardeConfig.auth.locationCookie);
            uri = URI.create(value);
        }
        Response.ResponseBuilder response = Response.seeOther((URI)uri);
        if (newCookie != null) {
            response.cookie(new NewCookie[]{newCookie});
        }
        return response.build();
    }

    public void redirectAfterLogin(URI uri) {
        throw new RedirectException(this.makeRedirectAfterLogin(uri));
    }

    public Response makeRedirectToLogin(String message) {
        if (this.request.uri().equals(this.config.getLoginPage())) {
            log.errorf("Redirect loop at %s, giving up on clearing bad JWT cookie", (Object)this.config.getLoginPage());
            return Response.serverError().build();
        }
        if (this.response.headers().contains("Location")) {
            this.response.headers().remove("Location");
        }
        Response.ResponseBuilder builder = Response.seeOther((URI)URI.create(this.config.getLoginPage()));
        builder.cookie(this.makeLogoutCookies());
        builder.cookie(new NewCookie[]{this.saveURICookie()});
        this.flash.flash("message", (Object)message);
        return builder.build();
    }

    public void redirectToLogin(String message) {
        throw new RedirectException(this.makeRedirectToLogin(message));
    }

    private NewCookie saveURICookie() {
        return ((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(this.locationCookie).path("/")).value(this.request.absoluteURI())).secure(this.request.isSSL())).build();
    }

    public NewCookie invalidateCookie(String cookieName) {
        return ((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(cookieName).path("/")).maxAge(0)).build();
    }

    public boolean hasUserCookie() {
        return this.request.getCookie(this.jwtCookie) != null;
    }
}

