/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.security.impl;

import io.quarkiverse.renarde.security.RenardeSecurity;
import io.quarkus.security.AuthenticationFailedException;
import io.vertx.core.http.HttpServerResponse;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jose4j.jwt.consumer.InvalidJwtException;

@ApplicationScoped
public class AuthenticationFailedExceptionMapper {
    @Inject
    RenardeSecurity renardeSecurity;

    @ServerExceptionMapper(priority=5000)
    public Response authenticationFailed(AuthenticationFailedException ex, HttpServerResponse vertxResponse) {
        if (!this.renardeSecurity.hasUserCookie()) {
            return null;
        }
        Object throwable = ex;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof InvalidJwtException) {
            InvalidJwtException x = (InvalidJwtException)throwable;
            if (x.hasErrorCode(1)) {
                return this.renardeSecurity.makeRedirectToLogin("Login expired, you've been logged out");
            }
            return this.renardeSecurity.makeRedirectToLogin("Invalid session (bad JWT), you've been logged out");
        }
        if (throwable instanceof AEADBadTagException || throwable instanceof BadPaddingException) {
            return this.renardeSecurity.makeRedirectToLogin("Invalid session (bad signature), you've been logged out");
        }
        return null;
    }
}

