/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.test;

import io.quarkus.csrf.reactive.runtime.CsrfTokenUtils;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;

public class CSRF {
    private static final SecureRandom secureRandom = new SecureRandom();

    public static String makeCSRFToken() {
        Optional tokenSignatureKey = ConfigProvider.getConfig().getOptionalValue("quarkus.csrf-reactive.token-signature-key", String.class);
        Optional tokenSize = ConfigProvider.getConfig().getOptionalValue("quarkus.csrf-reactive.token-size", Integer.class);
        byte[] tokenBytes = new byte[tokenSize.orElse(16).intValue()];
        secureRandom.nextBytes(tokenBytes);
        if (tokenSignatureKey.isPresent()) {
            return CsrfTokenUtils.signCsrfToken((byte[])tokenBytes, (String)((String)tokenSignatureKey.get()));
        }
        return Base64.getUrlEncoder().withoutPadding().encodeToString(tokenBytes);
    }

    public static String getTokenCookieName() {
        return ConfigProvider.getConfig().getOptionalValue("quarkus.csrf-reactive.cookie-name", String.class).orElse("csrf-token");
    }

    public static String getTokenFormName() {
        return ConfigProvider.getConfig().getOptionalValue("quarkus.csrf-reactive.form-field-name", String.class).orElse("csrf-token");
    }
}

