/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.test;

import io.quarkiverse.renarde.test.CSRF;
import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import io.restassured.filter.FilterContext;
import io.restassured.filter.OrderedFilter;
import io.restassured.http.Cookie;
import io.restassured.response.Response;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import io.restassured.specification.MultiPartSpecification;
import java.util.List;
import java.util.stream.Collectors;

public class CSRFFilter
implements OrderedFilter {
    public static void install() {
        for (Filter filter : RestAssured.filters()) {
            if (filter.getClass() != CSRFFilter.class) continue;
            return;
        }
        RestAssured.filters((Filter)new CSRFFilter(), (Filter[])new Filter[0]);
    }

    public static void deinstall() {
        boolean needsDeinstall = false;
        for (Filter filter2 : RestAssured.filters()) {
            if (filter2.getClass() != CSRFFilter.class) continue;
            needsDeinstall = true;
            break;
        }
        if (needsDeinstall) {
            List newFilters = RestAssured.filters().stream().filter(filter -> filter.getClass() != CSRFFilter.class).collect(Collectors.toList());
            RestAssured.replaceFiltersWith(newFilters);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private static boolean requestMethodIsSafe(String method) {
        switch (method) {
            case "GET": 
            case "HEAD": 
            case "OPTIONS": {
                return true;
            }
        }
        return false;
    }

    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        if (!CSRFFilter.requestMethodIsSafe(requestSpec.getMethod()) && this.isValidPayload(requestSpec.getContentType()) && !this.isAlreadyHandled(requestSpec)) {
            Cookie previousValue = requestSpec.getCookies().get(CSRF.getTokenCookieName());
            String token = previousValue != null ? previousValue.getValue() : CSRF.makeCSRFToken();
            requestSpec.cookie(CSRF.getTokenCookieName(), (Object)token, new Object[0]);
            String contentType = requestSpec.getContentType();
            if (contentType == null || this.isCompatible("application/x-www-form-urlencoded", contentType)) {
                requestSpec.formParam(CSRF.getTokenFormName(), new Object[]{token});
            } else {
                requestSpec.multiPart(CSRF.getTokenFormName(), token);
            }
        }
        return ctx.next(requestSpec, responseSpec);
    }

    private boolean isAlreadyHandled(FilterableRequestSpecification requestSpec) {
        String formName = CSRF.getTokenFormName();
        String previousFormToken = (String)requestSpec.getFormParams().get(formName);
        String previousMultipartToken = null;
        for (MultiPartSpecification part : requestSpec.getMultiPartParams()) {
            if (!formName.equals(part.getControlName())) continue;
            previousMultipartToken = (String)part.getContent();
            break;
        }
        return previousFormToken != null || previousMultipartToken != null;
    }

    private boolean isValidPayload(String contentType) {
        return contentType == null || this.isCompatible("application/x-www-form-urlencoded", contentType) || this.isCompatible("multipart/form-data", contentType);
    }

    private boolean isCompatible(String validContentType, String checkedContentType) {
        return checkedContentType != null && (validContentType.equals(checkedContentType) || checkedContentType.startsWith(validContentType + ";"));
    }
}

