/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.test;

import io.quarkiverse.renarde.test.CSRFFilter;
import io.quarkiverse.renarde.test.DisableCSRFFilter;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.test.junit.QuarkusTestExtension;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Optional;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class RenardeTestExtension
implements BeforeEachCallback {
    public void beforeEach(ExtensionContext context) throws Exception {
        ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.GLOBAL);
        Class testType = (Class)store.get((Object)"io.quarkus.testing.type", Class.class);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (testType == null || testType == QuarkusTestExtension.class) {
            Field field = QuarkusTestExtension.class.getDeclaredField("runningQuarkusApplication");
            field.setAccessible(true);
            RunningQuarkusApplication quarkusApplication = (RunningQuarkusApplication)field.get(null);
            if (quarkusApplication != null) {
                cl = quarkusApplication.getClassLoader();
            }
        }
        Class<?> csrfFilterClass = cl.loadClass(CSRFFilter.class.getName());
        if (this.disabledCSRF(context.getTestMethod()) || this.disabledCSRF(context.getTestClass())) {
            csrfFilterClass.getDeclaredMethod("deinstall", new Class[0]).invoke(null, new Object[0]);
        } else {
            csrfFilterClass.getDeclaredMethod("install", new Class[0]).invoke(null, new Object[0]);
        }
    }

    private boolean disabledCSRF(Optional<? extends AnnotatedElement> testElement) {
        if (testElement.isEmpty()) {
            return false;
        }
        return testElement.get().isAnnotationPresent(DisableCSRFFilter.class);
    }
}

