/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.util.RandomHolder;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpServerRequest;
import java.lang.annotation.Annotation;
import java.util.Base64;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.multipart.FormData;

@Named(value="CRSF")
@RequestScoped
public class CRSF {
    @Inject
    HttpServerRequest request;
    private String crsfToken;
    private static final int CRSF_SIZE = 16;
    private static final String CRSF_COOKIE_NAME = "_renarde_crsf";
    private static final String CRSF_FORM_NAME = "_renarde_crsf_token";

    public void setCRSFCookie() {
        if (!this.request.response().headWritten() && this.crsfToken != null) {
            this.request.response().addCookie(Cookie.cookie((String)CRSF_COOKIE_NAME, (String)this.crsfToken).setPath("/"));
        }
    }

    public void readCRSFCookie() {
        Cookie cookie = this.request.getCookie(CRSF_COOKIE_NAME);
        if (cookie != null) {
            this.crsfToken = cookie.getValue();
        } else {
            byte[] bytes = new byte[16];
            RandomHolder.SECURE_RANDOM.nextBytes(bytes);
            this.crsfToken = Base64.getEncoder().encodeToString(bytes);
        }
    }

    public void checkCRSFToken() {
        CurrentVertxRequest currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
        ResteasyReactiveRequestContext rrContext = (ResteasyReactiveRequestContext)currentVertxRequest.getOtherHttpContextObject();
        FormData formData = rrContext.getFormData();
        String formToken = null;
        if (formData != null) {
            FormData.FormValue value = formData.getFirst(CRSF_FORM_NAME);
            String string = formToken = value != null ? value.getValue() : null;
        }
        if (formToken == null || !formToken.equals(this.crsfToken)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid or missing CRSF Token").build());
        }
    }

    public String formName() {
        return CRSF_FORM_NAME;
    }

    public String token() {
        return this.crsfToken;
    }
}

