/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.util.CRSF;
import io.quarkiverse.renarde.util.Flash;
import io.quarkiverse.renarde.util.RenderArgs;
import io.quarkus.qute.TemplateInstance;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerResponseContext;
import org.jboss.resteasy.reactive.server.ServerRequestFilter;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;

public class Filters {
    @Inject
    RenderArgs renderArgs;
    @Inject
    Flash flash;
    @Inject
    CRSF crsf;

    @ServerRequestFilter(readBody=true)
    public void filterRequest(HttpServerRequest req) {
        this.flash.handleFlashCookie();
        this.crsf.readCRSFCookie();
        if (req.method() == HttpMethod.GET || req.method() == HttpMethod.HEAD || req.method() != HttpMethod.OPTIONS) {
            // empty if block
        }
    }

    @ServerResponseFilter
    public void filterResponse(ContainerResponseContext responseContext, HttpServerResponse resp) {
        Object entity = responseContext.getEntity();
        if (entity instanceof TemplateInstance) {
            TemplateInstance template = (TemplateInstance)entity;
            for (Map.Entry<String, Object> entry : this.renderArgs.entrySet()) {
                template.data(entry.getKey(), entry.getValue());
            }
        }
        this.flash.setFlashCookie();
        this.crsf.setCRSFCookie();
    }
}

