/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.util.JavaExtensions;
import io.quarkiverse.renarde.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Priority;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;

@Priority(value=5001)
@Provider
public class MyParamConverters
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (rawType == Date.class) {
            return new DateParamConverter();
        }
        if (rawType == Character.class || rawType == Character.TYPE) {
            return new CharacterParamConverter();
        }
        return null;
    }

    public static class CharacterParamConverter
    implements ParamConverter<Character> {
        public Character fromString(String value) {
            if (StringUtils.isEmpty(value)) {
                return null;
            }
            if (value.length() != 1) {
                throw new RuntimeException("Invalid character: " + value);
            }
            return Character.valueOf(value.charAt(0));
        }

        public String toString(Character value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }
    }

    public static class DateParamConverter
    implements ParamConverter<Date> {
        public Date fromString(String value) {
            if (StringUtils.isEmpty(value)) {
                return null;
            }
            if (value.matches("\\d{4}-\\d{2}-\\d{2}")) {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(value);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException("Don't know how to deserialise " + value + " as a Date");
        }

        public String toString(Date value) {
            if (value == null) {
                return null;
            }
            return JavaExtensions.internetDateFormat(value);
        }
    }
}

