/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.BitSet;

public class UriUtils {
    private static BitSet ALPHA;
    private static BitSet DIGIT;
    private static BitSet UNRESERVED;
    private static BitSet SUB_DELIMS;
    private static BitSet PCHAR;

    public static String encodeSegment(String segment) {
        int length = segment.codePointCount(0, segment.length());
        StringBuffer sb = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            int c = segment.codePointAt(i);
            if (PCHAR.get(c)) {
                sb.append((char)c);
                continue;
            }
            UriUtils.percentEncode(c, sb);
        }
        return sb.toString();
    }

    private static void percentEncode(int c, StringBuffer sb) {
        CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
        ByteBuffer out = ByteBuffer.allocate(4);
        CharBuffer in = CharBuffer.allocate(2);
        if (Character.isSupplementaryCodePoint(c)) {
            in.append(Character.highSurrogate(c));
            in.append(Character.lowSurrogate(c));
        } else {
            in.append((char)c);
        }
        in.flip();
        if (encoder.encode(in, out, true) != CoderResult.UNDERFLOW) {
            throw new RuntimeException("Illegal UTF-8 encoding for codepoint " + c);
        }
        out.flip();
        while (out.hasRemaining()) {
            sb.append("%");
            UriUtils.toHexa(out.get(), sb);
        }
    }

    private static void toHexa(byte b, StringBuffer sb) {
        byte h = (byte)((b & 0xF0) >> 4);
        byte l = (byte)(b & 0xF);
        UriUtils.toHexa2(h, sb);
        UriUtils.toHexa2(l, sb);
    }

    private static void toHexa2(byte l, StringBuffer sb) {
        if (l < 10) {
            sb.append(l);
        } else {
            sb.append((char)(l - 10 + 65));
        }
    }

    static {
        int c;
        ALPHA = new BitSet();
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            ALPHA.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            ALPHA.set(c);
        }
        DIGIT = new BitSet();
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            DIGIT.set(c);
        }
        UNRESERVED = new BitSet();
        UNRESERVED.or(ALPHA);
        UNRESERVED.or(DIGIT);
        UNRESERVED.set(45);
        UNRESERVED.set(46);
        UNRESERVED.set(95);
        UNRESERVED.set(126);
        SUB_DELIMS = new BitSet();
        SUB_DELIMS.set(33);
        SUB_DELIMS.set(36);
        SUB_DELIMS.set(38);
        SUB_DELIMS.set(39);
        SUB_DELIMS.set(40);
        SUB_DELIMS.set(41);
        SUB_DELIMS.set(42);
        SUB_DELIMS.set(43);
        SUB_DELIMS.set(44);
        SUB_DELIMS.set(59);
        SUB_DELIMS.set(61);
        PCHAR = new BitSet();
        PCHAR.or(UNRESERVED);
        PCHAR.or(SUB_DELIMS);
        PCHAR.set(58);
        PCHAR.set(64);
    }
}

