/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde;

import io.quarkiverse.renarde.util.Flash;
import io.quarkiverse.renarde.util.RedirectException;
import io.quarkiverse.renarde.util.RenderArgs;
import io.quarkiverse.renarde.util.Validation;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.resteasy.reactive.RestResponse;

public class Controller {
    @Inject
    protected SecurityIdentity identity;
    @Inject
    protected RenderArgs renderArgs;
    @Inject
    protected Validation validation;
    @Inject
    protected Flash flash;
    @Inject
    protected UriInfo uriInfo;

    protected boolean validationFailed() {
        if (this.validation.hasErrors()) {
            this.prepareForErrorRedirect();
            return true;
        }
        return false;
    }

    protected void prepareForErrorRedirect() {
        this.flash.flashParams();
        this.validation.keep();
    }

    protected void flash(String key, Object value) {
        this.flash.flash(key, value);
    }

    protected static String emptyAsNull(String val) {
        if (val == null || val.isEmpty()) {
            return null;
        }
        return val;
    }

    protected Response forbidden() {
        throw new WebApplicationException(403);
    }

    protected Response forbidden(String message) {
        throw new WebApplicationException(RestResponse.ResponseBuilder.create((RestResponse.Status)RestResponse.Status.FORBIDDEN, (Object)message).build().toResponse());
    }

    protected Response badRequest() {
        throw new WebApplicationException(400);
    }

    protected void notFoundIfNull(Object obj) {
        if (obj == null) {
            throw new WebApplicationException(RestResponse.notFound().toResponse());
        }
    }

    protected Response notFound(String message) {
        throw new WebApplicationException(RestResponse.ResponseBuilder.create((RestResponse.Status)RestResponse.Status.NOT_FOUND, (Object)message).build().toResponse());
    }

    protected Response notFound() {
        throw new WebApplicationException(404);
    }

    protected void beforeRedirect() {
    }

    protected Response seeOther(String uri) {
        try {
            return Controller.seeOther(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Response seeOther(URI uri) {
        throw new RedirectException(Response.seeOther((URI)uri).build());
    }

    protected Response temporaryRedirect(URI uri) {
        throw new WebApplicationException(Response.temporaryRedirect((URI)uri).build());
    }

    protected <T extends Controller> T redirect(Class<T> target) {
        throw new RuntimeException("This method can only be called when instrumented together with a view call to the result directly: redirect(FooController.class).method()");
    }
}

