/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.util.Flash;
import io.quarkus.vertx.web.RouteFilter;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.function.BiConsumer;
import javax.crypto.AEADBadTagException;
import org.jose4j.jwt.consumer.InvalidJwtException;

public class AuthenticationFailedExceptionMapper {
    @RouteFilter(value=100)
    void myFilter(RoutingContext rc) {
        rc.put("io.quarkus.vertx.http.auth-failure-handler", (Object)new BiConsumer<RoutingContext, Throwable>(){

            @Override
            public void accept(RoutingContext routingContext, Throwable throwable) {
                while (throwable.getCause() != null) {
                    throwable = throwable.getCause();
                }
                if (throwable instanceof InvalidJwtException) {
                    InvalidJwtException x = (InvalidJwtException)throwable;
                    if (x.hasErrorCode(1)) {
                        this.redirectToRoot(routingContext, "Login expired, you've been logged out");
                        return;
                    }
                    this.redirectToRoot(routingContext, "Invalid session (bad JWT), you've been logged out");
                }
                if (throwable instanceof AEADBadTagException) {
                    this.redirectToRoot(routingContext, "Invalid session (bad signature), you've been logged out");
                    return;
                }
            }

            private void redirectToRoot(RoutingContext routingContext, String message) {
                routingContext.removeCookie("QuarkusUser").setPath("/");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("message", message);
                Flash.setFlashCookie(routingContext.response(), map);
                routingContext.response().setStatusCode(303);
                routingContext.redirect("/");
            }
        });
        rc.next();
    }
}

