/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.util.Validation;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.multipart.FormData;
import org.jboss.resteasy.reactive.server.multipart.FormValue;

@Named(value="flash")
@RequestScoped
public class Flash {
    @Inject
    HttpServerRequest request;
    @Inject
    Validation validation;
    private Map<String, Object> values = new HashMap<String, Object>();
    private Map<String, Object> futureValues = new HashMap<String, Object>();
    public static final String FLASH_COOKIE_NAME = "_renarde_flash";

    public void setFlashCookie() {
        Flash.setFlashCookie(this.request.response(), this.futureValues);
    }

    public static void setFlashCookie(HttpServerResponse response, Map<String, Object> values) {
        if (!response.headWritten()) {
            response.addCookie(Cookie.cookie((String)FLASH_COOKIE_NAME, (String)Flash.encodeCookieValue(values)).setPath("/"));
        }
    }

    public static String encodeCookieValue(Map<String, Object> values) {
        return Base64.getEncoder().encodeToString(Flash.marshallMap(values));
    }

    public void handleFlashCookie() {
        Map<String, Object> data;
        Cookie cookie = this.request.getCookie(FLASH_COOKIE_NAME);
        if (cookie != null && (data = Flash.decodeCookieValue(cookie.getValue())) != null) {
            this.values.putAll(data);
            this.validation.loadErrorsFromFlash();
        }
        this.request.response().removeCookie(FLASH_COOKIE_NAME);
    }

    public static Map<String, Object> decodeCookieValue(String value) {
        byte[] decoded;
        byte[] bytes;
        if (value != null && !value.isEmpty() && (bytes = value.getBytes()) != null && bytes.length != 0 && (decoded = Base64.getDecoder().decode(bytes)).length > 0) {
            return Flash.unmarshallMap(decoded);
        }
        return null;
    }

    private static byte[] marshallMap(Map<String, Object> data) {
        String json = Json.encode(data);
        return json.getBytes(StandardCharsets.UTF_8);
    }

    private static Map<String, Object> unmarshallMap(byte[] data) {
        String json = new String(data, StandardCharsets.UTF_8);
        JsonObject obj = (JsonObject)Json.decodeValue((String)json);
        return obj.getMap();
    }

    public void flashParams() {
        CurrentVertxRequest currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
        ResteasyReactiveRequestContext rrContext = (ResteasyReactiveRequestContext)currentVertxRequest.getOtherHttpContextObject();
        FormData formData = rrContext.getFormData();
        if (formData != null) {
            for (String key : formData) {
                Deque values = formData.get(key);
                if (values.size() != 1) {
                    ArrayList<String> list = new ArrayList<String>(values.size());
                    for (FormValue val : values) {
                        if (!val.isFileItem()) {
                            list.add(val.getValue());
                        }
                        this.futureValues.put(key, list);
                    }
                    continue;
                }
                FormValue firstValue = formData.getFirst(key);
                if (firstValue.isFileItem()) continue;
                this.futureValues.put(key, firstValue.getValue());
            }
        }
    }

    public void flash(String key, Object value) {
        this.futureValues.put(key, value);
    }

    public <T> T get(String key) {
        return (T)this.values.get(key);
    }

    public Map<String, Object> values() {
        return this.values;
    }
}

