/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.router.Router;
import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ValueResolver;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.event.Observes;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;

public class QuteResolvers {
    void configureEngine(@Observes EngineBuilder builder) {
        builder.addValueResolver(ValueResolver.builder().appliesTo(ctx -> ctx.getBase() instanceof BoundRouter).resolveSync(ctx -> {
            List params = ctx.getParams();
            if (params.isEmpty()) {
                return CompletedStage.of((Object)this.findURI((EvalContext)ctx, Collections.emptyList()));
            }
            ArrayList<Uni> unis = new ArrayList<Uni>(params.size());
            for (int i = 0; i < params.size(); ++i) {
                CompletionStage val = ctx.evaluate((Expression)params.get(i));
                Uni uni = Uni.createFrom().completionStage(val);
                unis.add(uni);
            }
            return Uni.combine().all().unis(unis).collectFailures().combinedWith(paramValues -> this.findURI((EvalContext)ctx, (List<?>)paramValues)).convert().toCompletionStage();
        }).build());
        builder.addNamespaceResolver(NamespaceResolver.builder((String)"uri").resolve(ctx -> new BoundRouter(ctx.getName(), false)).build());
        builder.addNamespaceResolver(NamespaceResolver.builder((String)"uriabs").resolve(ctx -> new BoundRouter(ctx.getName(), true)).build());
    }

    private URI findURI(EvalContext ctx, List<?> paramValues) {
        BoundRouter boundRouter = (BoundRouter)ctx.getBase();
        String route = boundRouter.target + "." + ctx.getName();
        return Router.findURI(route, boundRouter.absolute, paramValues.toArray());
    }

    static class BoundRouter {
        public final String target;
        public final boolean absolute;

        public BoundRouter(String target, boolean absolute) {
            this.target = target;
            this.absolute = absolute;
        }
    }
}

