/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.impl.RenardeConfig;
import io.quarkus.smallrye.jwt.runtime.auth.JWTAuthMechanism;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.Cookie;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;

@Priority(value=2000)
@ApplicationScoped
public class RenardeJWTAuthMechanism
extends JWTAuthMechanism {
    @Inject
    RenardeConfig config;
    String locationCookie = "quarkus-redirect-location";

    public int getPriority() {
        return -1000;
    }

    protected void storeInitialLocation(RoutingContext exchange) {
        exchange.response().addCookie(Cookie.cookie((String)this.locationCookie, (String)exchange.request().absoluteURI()).setPath("/").setSecure(exchange.request().isSSL()));
    }

    static Uni<ChallengeData> getRedirect(RoutingContext exchange, String location) {
        String loc = exchange.request().scheme() + "://" + exchange.request().host() + location;
        return Uni.createFrom().item((Object)new ChallengeData(302, (CharSequence)"Location", loc));
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        if (this.config.getLoginPage() != null) {
            this.storeInitialLocation(context);
            return RenardeJWTAuthMechanism.getRedirect(context, this.config.getLoginPage());
        }
        return super.getChallenge(context);
    }
}

