/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.impl.RenardeConfigBean;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;

@Named(value="i18n")
@RequestScoped
public class I18N {
    public static final String LOCALE_COOKIE_NAME = "_renarde_locale";
    @Deprecated
    public static final String LANGUAGE_COOKIE_NAME = "_renarde_locale";
    @Inject
    HttpServerRequest request;
    @Inject
    LocalesBuildTimeConfig localesConfig;
    @Inject
    RenardeConfigBean renardeConfig;
    private Locale locale = null;
    private boolean localeOverridden = false;

    public void set(String language) {
        this.setForCurrentRequest(language);
        this.localeOverridden = true;
    }

    public void setForCurrentRequest(String language) {
        Objects.requireNonNull(language);
        Locale found = this.findSupportedLocale(language);
        if (this.locale == null) {
            throw new IllegalArgumentException("Language " + language + " not supported, please add it to the 'quarkus.locales' configuration");
        }
        this.locale = found;
    }

    private Locale findSupportedLocale(String language) {
        for (Locale locale : this.localesConfig.locales) {
            if (!locale.getLanguage().equals(language)) continue;
            return locale;
        }
        return null;
    }

    @Deprecated
    public String get() {
        return this.getLanguage();
    }

    public String getLanguage() {
        return this.getLocale().getLanguage();
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : this.localesConfig.defaultLocale;
    }

    void readLanguageCookie(ResteasyReactiveContainerRequestContext requestContext) {
        Locale acceptableLanguage;
        Cookie cookie = (Cookie)requestContext.getCookies().get("_renarde_locale");
        if (cookie != null) {
            this.locale = this.findSupportedLocale(cookie.getValue());
            if (this.locale != null) {
                return;
            }
        }
        List acceptableLanguages = HeaderUtil.getAcceptableLanguages((MultivaluedMap)requestContext.getHeaders());
        Iterator iterator = acceptableLanguages.iterator();
        while (iterator.hasNext() && !(acceptableLanguage = (Locale)iterator.next()).getLanguage().equals("*")) {
            if (!this.localesConfig.locales.contains(acceptableLanguage)) continue;
            this.locale = acceptableLanguage;
            return;
        }
        this.locale = this.localesConfig.defaultLocale;
    }

    void setLanguageCookie() {
        HttpServerResponse response = this.request.response();
        if (this.localeOverridden && !response.headWritten()) {
            response.addCookie(io.vertx.core.http.Cookie.cookie((String)"_renarde_locale", (String)this.locale.toString()).setPath("/").setSameSite(CookieSameSite.LAX).setSecure(this.request.isSSL()));
        }
    }

    public String getMessage(String key) {
        return this.renardeConfig.getMessage(this.get(), key);
    }

    public String formatMessage(String key, Object ... params) {
        String message = this.getMessage(key);
        return message != null ? String.format(message, params) : key;
    }
}

