/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkiverse.renarde.impl.RenardeConfigBean;
import io.quarkus.smallrye.jwt.runtime.auth.JWTAuthMechanism;
import io.quarkus.smallrye.jwt.runtime.auth.SmallRyeJwtConfig;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.Cookie;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Priority(value=2000)
@ApplicationScoped
public class RenardeJWTAuthMechanism
extends JWTAuthMechanism {
    private static final Logger log = Logger.getLogger(RenardeJWTAuthMechanism.class);
    @Inject
    RenardeConfigBean config;
    @ConfigProperty(name="quarkus.renarde.auth.location-cookie")
    String locationCookie;

    RenardeJWTAuthMechanism() {
        this(null);
    }

    public RenardeJWTAuthMechanism(SmallRyeJwtConfig config) {
        super(config);
    }

    public int getPriority() {
        return -1000;
    }

    protected void storeInitialLocation(RoutingContext exchange) {
        exchange.response().addCookie(Cookie.cookie((String)this.locationCookie, (String)exchange.request().absoluteURI()).setPath("/").setSecure(exchange.request().isSSL()));
    }

    static Uni<ChallengeData> getRedirect(RoutingContext exchange, String location) {
        String loc = exchange.request().scheme() + "://" + exchange.request().host() + location;
        return Uni.createFrom().item((Object)new ChallengeData(302, (CharSequence)"Location", loc));
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        String authHeader = context.request().headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        if (authHeader != null) {
            return super.getChallenge(context);
        }
        if (context.request().uri().equals(this.config.getLoginPage())) {
            log.errorf("Avoiding redirect loop, make sure that your endpoint annotated with @LoginPage is accessible without being authenticated: %s", (Object)this.config.getLoginPage());
            return super.getChallenge(context);
        }
        this.storeInitialLocation(context);
        return RenardeJWTAuthMechanism.getRedirect(context, this.config.getLoginPage());
    }
}

