/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.util.Flash;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import jakarta.validation.Validator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Named(value="validation")
@RequestScoped
public class Validation {
    @Inject
    Validator validator;
    @Inject
    Flash flash;
    private List<Error> errors = new ArrayList<Error>();

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public void keep() {
        for (Error error : this.errors) {
            this.flash.flash("error." + error.field, error.message);
        }
    }

    public void required(String field, Object value) {
        if (value == null || value instanceof String && ((String)value).isEmpty()) {
            this.addError(field, "Required");
        }
    }

    public void addError(String field, String message) {
        this.errors.add(new Error(field, message));
    }

    public boolean hasError(String field) {
        for (Error error : this.errors) {
            if (!error.field.equals(field)) continue;
            return true;
        }
        return false;
    }

    public String getError(String field) {
        for (Error error : this.errors) {
            if (!error.field.equals(field)) continue;
            return error.message;
        }
        return null;
    }

    public void minSize(String field, String value, int size) {
        if (value == null || value.length() < size) {
            this.addError(field, "Must be at least " + size + " characters long");
        }
    }

    public void maxSize(String field, String value, int size) {
        if (value == null || value.length() > size) {
            this.addError(field, "Must be at most " + size + " characters long");
        }
    }

    public void equals(String field, Object a, Object b) {
        if (!Objects.equals(a, b)) {
            this.addError(field, "Must be equal");
        }
    }

    public void future(String field, Date date) {
        if (!date.after(new Date())) {
            this.addError(field, "Must be in the future");
        }
    }

    public void addErrors(Set<ConstraintViolation<Object>> violations) {
        for (ConstraintViolation<Object> violation : violations) {
            Iterator iterator = violation.getPropertyPath().iterator();
            String lastNode = null;
            while (iterator.hasNext()) {
                lastNode = ((Path.Node)iterator.next()).getName();
            }
            this.addError(lastNode, violation.getMessage());
        }
    }

    public void loadErrorsFromFlash() {
        for (Map.Entry<String, Object> entry : this.flash.values().entrySet()) {
            if (!entry.getKey().startsWith("error.")) continue;
            String field = entry.getKey().substring(6);
            this.addError(field, (String)entry.getValue());
        }
    }

    public static class Error {
        public final String field;
        public final String message;

        public Error(String field, String message) {
            this.field = field;
            this.message = message;
        }

        public String toString() {
            return "[Error field=" + this.field + ", message=" + this.message + "]";
        }
    }
}

