/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkus.arc.Arc;
import io.quarkus.csrf.reactive.runtime.CsrfTokenParameterProvider;
import io.quarkus.qute.TemplateGlobal;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import org.jboss.resteasy.reactive.server.SimpleResourceInfo;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;

@TemplateGlobal
public class Globals {
    public static CsrfTokenParameterProvider csrf() {
        return (CsrfTokenParameterProvider)Arc.container().instance(CsrfTokenParameterProvider.class, new Annotation[0]).get();
    }

    public static RenardeRequest request() {
        return RenardeRequest.INSTANCE;
    }

    public static class RenardeRequest {
        public static final RenardeRequest INSTANCE = new RenardeRequest();

        public String getUrl() {
            ResteasyReactiveRequestContext request = CurrentRequestManager.get();
            return request.getAbsoluteURI();
        }

        public String getPath() {
            ResteasyReactiveRequestContext request = CurrentRequestManager.get();
            return request.getPath();
        }

        public String getScheme() {
            ResteasyReactiveRequestContext request = CurrentRequestManager.get();
            return request.getScheme();
        }

        public String getAuthority() {
            ResteasyReactiveRequestContext request = CurrentRequestManager.get();
            return request.getAuthority();
        }

        public String getMethod() {
            ResteasyReactiveRequestContext request = CurrentRequestManager.get();
            return request.getMethod();
        }

        public String getHost() {
            RoutingContext ctx = (RoutingContext)Arc.container().instance(RoutingContext.class, new Annotation[0]).get();
            return ctx.request().authority().host();
        }

        public int getPort() {
            RoutingContext ctx = (RoutingContext)Arc.container().instance(RoutingContext.class, new Annotation[0]).get();
            return ctx.request().authority().port();
        }

        public boolean isSsl() {
            RoutingContext ctx = (RoutingContext)Arc.container().instance(RoutingContext.class, new Annotation[0]).get();
            return ctx.request().isSSL();
        }

        public String getRemoteAddress() {
            RoutingContext ctx = (RoutingContext)Arc.container().instance(RoutingContext.class, new Annotation[0]).get();
            return ctx.request().remoteAddress().hostAddress();
        }

        public String getRemoteHost() {
            RoutingContext ctx = (RoutingContext)Arc.container().instance(RoutingContext.class, new Annotation[0]).get();
            return ctx.request().remoteAddress().hostName();
        }

        public int getRemotePort() {
            RoutingContext ctx = (RoutingContext)Arc.container().instance(RoutingContext.class, new Annotation[0]).get();
            return ctx.request().remoteAddress().port();
        }

        public String getAction() {
            ResteasyReactiveRequestContext request = CurrentRequestManager.get();
            SimpleResourceInfo info = request.getTarget().getSimplifiedResourceInfo();
            return info.getResourceClass().getSimpleName() + "." + info.getMethodName();
        }
    }
}

