/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.impl;

import jakarta.enterprise.context.ApplicationScoped;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

@ApplicationScoped
public class RenardeConfig {
    private String loginPage;
    private Map<String, Properties> bundles = new HashMap<String, Properties>();

    public String getLoginPage() {
        return this.loginPage;
    }

    void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public Properties getMessageBundle(String language) {
        return this.bundles.get(language);
    }

    public String getMessage(String language, String key) {
        Properties bundle = this.getMessageBundle(language);
        return bundle != null ? bundle.getProperty(key) : null;
    }

    void addLanguageBundle(String language, String bundlePath) {
        ClassLoader cl;
        Properties bundle = new Properties();
        if (!((String)bundlePath).startsWith("/")) {
            bundlePath = "/" + (String)bundlePath;
        }
        if ((cl = Thread.currentThread().getContextClassLoader()) == null) {
            cl = RenardeConfig.class.getClassLoader();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(cl.getResourceAsStream((String)bundlePath), StandardCharsets.UTF_8));){
            bundle.load(reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.bundles.put(language, bundle);
    }
}

