/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.util.Flash;
import io.quarkus.security.AuthenticationFailedException;
import io.vertx.core.http.HttpServerRequest;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.HashMap;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jose4j.jwt.consumer.InvalidJwtException;

@ApplicationScoped
public class AuthenticationFailedExceptionMapper {
    @Inject
    Flash flash;
    @Inject
    HttpServerRequest request;

    @ServerExceptionMapper(priority=5000)
    public Response authenticationFailed(AuthenticationFailedException ex) {
        Object throwable = ex;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof InvalidJwtException) {
            InvalidJwtException x = (InvalidJwtException)throwable;
            if (x.hasErrorCode(1)) {
                return this.redirectToRoot("Login expired, you've been logged out");
            }
            return this.redirectToRoot("Invalid session (bad JWT), you've been logged out");
        }
        if (throwable instanceof AEADBadTagException || throwable instanceof BadPaddingException) {
            return this.redirectToRoot("Invalid session (bad signature), you've been logged out");
        }
        return null;
    }

    private Response redirectToRoot(String message) {
        this.flash.flash("message", message);
        Response.ResponseBuilder builder = Response.seeOther((URI)URI.create("/"));
        NewCookie logoutCookie = new NewCookie("QuarkusUser", "", "/", null, 1, null, -1, null, false, false);
        builder.cookie(new NewCookie[]{logoutCookie});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("message", message);
        Flash.setFlashCookie(this.request, this.request.response(), map);
        return builder.build();
    }
}

