/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.util.Flash;
import io.quarkiverse.renarde.util.I18N;
import io.quarkiverse.renarde.util.RenderArgs;
import io.quarkus.qute.TemplateInstance;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerResponseContext;
import java.util.Map;
import org.jboss.resteasy.reactive.server.ServerRequestFilter;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;

public class Filters {
    @Inject
    RenderArgs renderArgs;
    @Inject
    Flash flash;
    @Inject
    I18N i18n;

    @ServerRequestFilter
    public void filterRequest(ResteasyReactiveContainerRequestContext requestContext, HttpServerRequest req) {
        this.flash.handleFlashCookie();
        this.i18n.readLanguageCookie(requestContext);
    }

    @ServerResponseFilter(priority=6000)
    public void filterResponse(ContainerResponseContext responseContext, HttpServerResponse resp) {
        Object entity = responseContext.getEntity();
        if (entity instanceof TemplateInstance) {
            TemplateInstance template = (TemplateInstance)entity;
            this.setTemplateLocaleAndRenderArgs(template);
        }
        this.i18n.setLanguageCookie();
        this.flash.setFlashCookie();
    }

    void setTemplateLocaleAndRenderArgs(TemplateInstance template) {
        for (Map.Entry<String, Object> entry : this.renderArgs.entrySet()) {
            template.data(entry.getKey(), entry.getValue());
        }
        template.setAttribute("locale", (Object)this.i18n.get());
    }
}

