/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.impl.RenardeConfig;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;

@Named(value="i18n")
@RequestScoped
public class I18N {
    public static final String LANGUAGE_COOKIE_NAME = "_renarde_language";
    @Inject
    HttpServerRequest request;
    @Inject
    LocalesBuildTimeConfig localesConfig;
    @Inject
    RenardeConfig renardeConfig;
    private String language = null;
    private boolean languageOverridden = false;

    public void set(String language) {
        Objects.requireNonNull(language);
        boolean found = false;
        for (Locale locale : this.localesConfig.locales) {
            if (!locale.getLanguage().equals(language)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Language " + language + " not supported, please add it to the 'quarkus.locales' configuration");
        }
        this.languageOverridden = true;
        this.language = language;
    }

    public String get() {
        return this.language;
    }

    void readLanguageCookie(ResteasyReactiveContainerRequestContext requestContext) {
        Locale acceptableLanguage;
        Cookie cookie = (Cookie)requestContext.getCookies().get(LANGUAGE_COOKIE_NAME);
        if (cookie != null) {
            this.language = cookie.getValue();
            return;
        }
        List acceptableLanguages = HeaderUtil.getAcceptableLanguages((MultivaluedMap)requestContext.getHeaders());
        Iterator iterator = acceptableLanguages.iterator();
        while (iterator.hasNext() && !(acceptableLanguage = (Locale)iterator.next()).getLanguage().equals("*")) {
            if (!this.localesConfig.locales.contains(acceptableLanguage)) continue;
            this.language = acceptableLanguage.getLanguage();
            return;
        }
        this.language = this.localesConfig.defaultLocale.getLanguage();
    }

    void setLanguageCookie() {
        HttpServerResponse response = this.request.response();
        if (this.languageOverridden && !response.headWritten()) {
            response.addCookie(io.vertx.core.http.Cookie.cookie((String)LANGUAGE_COOKIE_NAME, (String)this.language).setPath("/").setSameSite(CookieSameSite.LAX).setSecure(this.request.isSSL()));
        }
    }

    public String getMessage(String key) {
        return this.renardeConfig.getMessage(this.get(), key);
    }

    public String formatMessage(String key, Object ... params) {
        String message = this.getMessage(key);
        return message != null ? String.format(message, params) : key;
    }
}

