/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.util.Filters;
import io.quarkus.arc.Arc;
import io.quarkus.qute.TemplateInstance;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class TemplateResponseHandler
implements ServerRestHandler {
    public void handle(ResteasyReactiveRequestContext requestContext) {
        Object result = requestContext.getResult();
        if (result instanceof TemplateInstance) {
            this.setRenderArgsAndLocale(requestContext, (TemplateInstance)result);
        } else if (result instanceof Uni) {
            Uni res = (Uni)result;
            requestContext.setResult((Object)res.invoke(resolved -> {
                if (resolved instanceof TemplateInstance) {
                    this.setRenderArgsAndLocale(requestContext, (TemplateInstance)resolved);
                }
            }));
        } else if (result instanceof CompletionStage) {
            CompletionStage res = (CompletionStage)result;
            requestContext.setResult(res.thenApply(resolved -> {
                if (resolved instanceof TemplateInstance) {
                    this.setRenderArgsAndLocale(requestContext, (TemplateInstance)resolved);
                }
                return resolved;
            }));
        }
    }

    private void setRenderArgsAndLocale(ResteasyReactiveRequestContext requestContext, TemplateInstance templateInstance) {
        requestContext.requireCDIRequestScope();
        Filters filters = (Filters)Arc.container().instance(Filters.class, new Annotation[0]).get();
        filters.setTemplateLocaleAndRenderArgs(templateInstance);
    }
}

