/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.impl;

import jakarta.enterprise.context.ApplicationScoped;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

@ApplicationScoped
public class RenardeConfig {
    private String loginPage;
    private Map<String, Properties> bundles = new HashMap<String, Properties>();

    public String getLoginPage() {
        return this.loginPage;
    }

    void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public Properties getMessageBundle(String language) {
        return this.bundles.get(language);
    }

    public String getMessage(String language, String key) {
        Properties bundle = this.getMessageBundle(language);
        return bundle != null ? bundle.getProperty(key) : null;
    }

    void addLanguageBundle(String language, String bundlePath) {
        Properties bundle = new Properties();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = RenardeConfig.class.getClassLoader();
        }
        try {
            Enumeration<URL> resources = cl.getResources(bundlePath);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                    bundle.load(reader);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                Properties properties = this.bundles.get(language);
                if (properties == null) {
                    this.bundles.put(language, bundle);
                    continue;
                }
                properties.putAll((Map<?, ?>)bundle);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

