/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.impl.RenardeConfig;
import io.quarkiverse.renarde.util.Flash;
import io.quarkus.security.AuthenticationFailedException;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.HashMap;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jose4j.jwt.consumer.InvalidJwtException;

@ApplicationScoped
public class AuthenticationFailedExceptionMapper {
    @Inject
    Flash flash;
    @Inject
    HttpServerRequest request;
    @Inject
    RenardeConfig config;
    @ConfigProperty(name="mp.jwt.token.cookie")
    String jwtCookie;

    @ServerExceptionMapper(priority=5000)
    public Response authenticationFailed(AuthenticationFailedException ex, HttpServerResponse vertxResponse) {
        Object throwable = ex;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof InvalidJwtException) {
            InvalidJwtException x = (InvalidJwtException)throwable;
            if (x.hasErrorCode(1)) {
                return this.redirectToRoot("Login expired, you've been logged out", vertxResponse);
            }
            return this.redirectToRoot("Invalid session (bad JWT), you've been logged out", vertxResponse);
        }
        if (throwable instanceof AEADBadTagException || throwable instanceof BadPaddingException) {
            return this.redirectToRoot("Invalid session (bad signature), you've been logged out", vertxResponse);
        }
        return null;
    }

    private Response redirectToRoot(String message, HttpServerResponse vertxResponse) {
        this.flash.flash("message", message);
        if (vertxResponse.headers().contains("Location")) {
            vertxResponse.headers().remove("Location");
        }
        String target = this.config.getLoginPage() != null ? this.config.getLoginPage() : "/";
        Response.ResponseBuilder builder = Response.seeOther((URI)URI.create(target));
        builder.cookie(new NewCookie[]{AuthenticationFailedExceptionMapper.invalidateCookie(this.jwtCookie)});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("message", message);
        Flash.setFlashCookie(this.request, this.request.response(), map);
        return builder.build();
    }

    public static NewCookie invalidateCookie(String cookieName) {
        return ((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(cookieName).path("/")).maxAge(0)).build();
    }
}

