/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.router.Router;
import io.quarkiverse.renarde.util.I18N;
import io.quarkiverse.renarde.util.RenderArgs;
import io.quarkus.arc.Arc;
import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ValueResolver;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.event.Observes;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;

public class QuteResolvers {
    void configureEngine(@Observes EngineBuilder builder) {
        builder.addValueResolver(ValueResolver.builder().appliesTo(ctx -> ctx.getBase() instanceof MessageKey).resolveSync(ctx -> {
            MessageKey base = (MessageKey)ctx.getBase();
            String name = ctx.getName().strip();
            if (name.equals("+")) {
                if (ctx.getParams().isEmpty()) {
                    base.isPendingAppendOperation = true;
                    return base;
                }
                base.isPendingAppendOperation = false;
                return QuteResolvers.evaluateParameters(ctx, (ctx2, params) -> {
                    if (params.size() == 1) {
                        return base.append(params.get(0).toString(), false);
                    }
                    throw new RuntimeException("'+' operator must have exactly one right-hand-side expressions");
                });
            }
            if (base.isPendingAppendOperation) {
                if (name.endsWith(")")) {
                    name = name.substring(0, name.length() - 1);
                }
                if (name.startsWith("'") && name.endsWith("'")) {
                    name = name.substring(1, name.length() - 1);
                }
            }
            MessageKey key = base.append(name, !base.isPendingAppendOperation);
            base.isPendingAppendOperation = false;
            return key.renderIfParameters((EvalContext)ctx);
        }).build());
        builder.addNamespaceResolver(NamespaceResolver.builder((String)"m").resolve(ctx -> new MessageKey(ctx.getName()).renderIfParameters((EvalContext)ctx)).build());
        builder.addValueResolver(ValueResolver.builder().appliesTo(ctx -> ctx.getBase() instanceof BoundRouter).resolveSync(ctx -> QuteResolvers.evaluateParameters(ctx, this::findURI)).build());
        builder.addNamespaceResolver(NamespaceResolver.builder((String)"uri").resolve(ctx -> new BoundRouter(ctx.getName(), false)).build());
        builder.addNamespaceResolver(NamespaceResolver.builder((String)"uriabs").resolve(ctx -> new BoundRouter(ctx.getName(), true)).build());
    }

    void registerTemplateInstanceLocaleAndRenderArgs(@Observes EngineBuilder engineBuilder, I18N i18n, RenderArgs renderArgs) {
        engineBuilder.addTemplateInstanceInitializer(templateInstance -> {
            if (Arc.container().requestContext().isActive()) {
                if (i18n.getLocale() != null && templateInstance.getAttribute("locale") == null) {
                    templateInstance.setAttribute("locale", (Object)i18n.getLocale());
                }
                for (Map.Entry<String, Object> entry : renderArgs.entrySet()) {
                    templateInstance.data(entry.getKey(), entry.getValue());
                }
            }
        });
    }

    private URI findURI(EvalContext ctx, List<?> paramValues) {
        BoundRouter boundRouter = (BoundRouter)ctx.getBase();
        String route = boundRouter.target + "." + ctx.getName();
        return Router.findURI(route, boundRouter.absolute, paramValues.toArray());
    }

    static <R> CompletionStage<R> evaluateParameters(EvalContext ctx, BiFunction<EvalContext, List<?>, R> mapper) {
        List params = ctx.getParams();
        if (params.isEmpty()) {
            return CompletedStage.of(mapper.apply(ctx, Collections.emptyList()));
        }
        ArrayList<Uni> unis = new ArrayList<Uni>(params.size());
        for (int i = 0; i < params.size(); ++i) {
            CompletionStage val = ctx.evaluate((Expression)params.get(i));
            Uni uni = Uni.createFrom().completionStage(val);
            unis.add(uni);
        }
        return Uni.combine().all().unis(unis).collectFailures().combinedWith(paramValues -> mapper.apply(ctx, (List<?>)paramValues)).convert().toCompletionStage();
    }

    static class BoundRouter {
        public final String target;
        public final boolean absolute;

        public BoundRouter(String target, boolean absolute) {
            this.target = target;
            this.absolute = absolute;
        }
    }

    static class MessageKey {
        public final String key;
        public boolean isPendingAppendOperation;

        public MessageKey(String key) {
            this.key = key.startsWith("'") && key.endsWith("'") ? key.substring(1, key.length() - 1) : key;
        }

        public MessageKey append(String postfix, boolean addDot) {
            if (!addDot) {
                return new MessageKey(this.key + postfix);
            }
            return new MessageKey(this.key + "." + postfix);
        }

        public String toString() {
            return this.render(new Object[0]);
        }

        public String render(Object ... params) {
            I18N i18n = (I18N)Arc.container().instance(I18N.class, new Annotation[0]).get();
            String message = i18n.getMessage(this.key);
            if (message == null) {
                return this.key;
            }
            return String.format(message, params);
        }

        public Object renderIfParameters(EvalContext ctx) {
            if (ctx.getParams().isEmpty()) {
                return this;
            }
            return QuteResolvers.evaluateParameters(ctx, (ctx2, params) -> this.render(params.toArray()));
        }
    }
}

