/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.resteasy.problem.deployment;

import io.quarkiverse.resteasy.problem.HttpProblem;
import io.quarkiverse.resteasy.problem.deployment.ProblemBuildConfig;
import io.smallrye.openapi.internal.models.media.MediaType;
import io.smallrye.openapi.internal.models.media.Schema;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;

public class OpenApiProblemFilter
implements OASFilter {
    private final ProblemBuildConfig config;
    private final io.smallrye.openapi.internal.models.media.Content problemContent;
    private final io.smallrye.openapi.internal.models.media.Content validationProblemContent;

    public OpenApiProblemFilter(ProblemBuildConfig config) {
        this.config = config;
        this.problemContent = OpenApiProblemFilter.createContent(config.openapi().defaultSchema());
        this.validationProblemContent = OpenApiProblemFilter.createContent(config.openapi().validationProblemSchema());
    }

    public Operation filterOperation(Operation operation) {
        if (operation.getResponses().hasAPIResponse("[HttpValidationProblem]")) {
            APIResponse response = operation.getResponses().getAPIResponse("[HttpValidationProblem]").description(this.config.constraintViolation().description()).content((Content)this.validationProblemContent);
            operation.getResponses().addAPIResponse(String.valueOf(this.config.constraintViolation().status()), response);
            operation.getResponses().removeAPIResponse("[HttpValidationProblem]");
        }
        return operation;
    }

    public APIResponse filterAPIResponse(APIResponse apiResponse) {
        if (apiResponse == null || apiResponse.getRef() != null || apiResponse.getContent() != null) {
            return apiResponse;
        }
        if (!(apiResponse instanceof io.smallrye.openapi.internal.models.responses.APIResponse)) {
            return apiResponse;
        }
        io.smallrye.openapi.internal.models.responses.APIResponse internalResponse = (io.smallrye.openapi.internal.models.responses.APIResponse)apiResponse;
        String responseCode = (String)internalResponse.getExtension("x-smallrye-private-response-code");
        if (responseCode == null || responseCode.isEmpty()) {
            return apiResponse;
        }
        try {
            int httpStatus = Integer.parseInt(responseCode);
            if (httpStatus >= 400) {
                apiResponse.setContent((Content)this.problemContent);
            }
        }
        catch (NumberFormatException e) {
            return apiResponse;
        }
        return apiResponse;
    }

    private static io.smallrye.openapi.internal.models.media.Content createContent(String schemaName) {
        Schema schema = new Schema();
        schema.setRef("#/components/schemas/" + schemaName);
        MediaType mediaType = new MediaType();
        mediaType.setSchema((org.eclipse.microprofile.openapi.models.media.Schema)schema);
        io.smallrye.openapi.internal.models.media.Content content = new io.smallrye.openapi.internal.models.media.Content();
        content.addMediaType(HttpProblem.MEDIA_TYPE.toString(), (org.eclipse.microprofile.openapi.models.media.MediaType)mediaType);
        return content;
    }
}

