/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.resteasy.problem.deployment;

import io.quarkiverse.resteasy.problem.ProblemRuntimeConfig;
import io.quarkiverse.resteasy.problem.deployment.ExceptionMapperDefinition;
import io.quarkiverse.resteasy.problem.deployment.JacksonDetector;
import io.quarkiverse.resteasy.problem.deployment.JsonBDetector;
import io.quarkiverse.resteasy.problem.deployment.OpenApiDetector;
import io.quarkiverse.resteasy.problem.deployment.OpenApiProblemFilter;
import io.quarkiverse.resteasy.problem.deployment.ProblemBuildConfig;
import io.quarkiverse.resteasy.problem.deployment.QuarkusSmallryeMetricsDetector;
import io.quarkiverse.resteasy.problem.deployment.RestEasyClassicDetector;
import io.quarkiverse.resteasy.problem.deployment.RestEasyReactiveDetector;
import io.quarkiverse.resteasy.problem.postprocessing.ProblemPostProcessor;
import io.quarkiverse.resteasy.problem.postprocessing.ProblemRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.jsonb.spi.JsonbDeserializerBuildItem;
import io.quarkus.jsonb.spi.JsonbSerializerBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import io.quarkus.smallrye.openapi.deployment.spi.AddToOpenAPIDefinitionBuildItem;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.OASFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProblemProcessor {
    private static final String FEATURE_NAME = "resteasy-problem";
    private static final String EXTENSION_MAIN_PACKAGE = "io.quarkiverse.resteasy.problem.";
    private static final List<String> RESTEASY_JSON_CAPABILITIES = Arrays.asList("io.quarkus.resteasy.json", "io.quarkus.resteasy-json", "io.quarkus.jsonb", "io.quarkus.jackson");

    private static List<ExceptionMapperDefinition> neededExceptionMappers() {
        Stream<ExceptionMapperDefinition> allMappers = Stream.of(ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.HttpProblemMapper").thatHandles("io.quarkiverse.resteasy.problem.HttpProblem"), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.jaxrs.WebApplicationExceptionMapper").thatHandles("jakarta.ws.rs.WebApplicationException"), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.jaxrs.JaxRsForbiddenExceptionMapper").thatHandles("jakarta.ws.rs.ForbiddenException"), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.jaxrs.NotFoundExceptionMapper").thatHandles("jakarta.ws.rs.NotFoundException"), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.jsonb.RestEasyClassicJsonbExceptionMapper").thatHandles("jakarta.ws.rs.ProcessingException"), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.security.UnauthorizedExceptionMapper").thatHandles("io.quarkus.security.UnauthorizedException").onlyIf(new RestEasyClassicDetector()), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.security.AuthenticationFailedExceptionMapper").thatHandles("io.quarkus.security.AuthenticationFailedException").onlyIf(new RestEasyClassicDetector()), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.security.AuthenticationRedirectExceptionMapper").thatHandles("io.quarkus.security.AuthenticationRedirectException"), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.security.AuthenticationCompletionExceptionMapper").thatHandles("io.quarkus.security.AuthenticationCompletionException"), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.security.ForbiddenExceptionMapper").thatHandles("io.quarkus.security.ForbiddenException"), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.validation.ValidationExceptionMapper").thatHandles("jakarta.validation.ValidationException"), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.validation.ConstraintViolationExceptionMapper").thatHandles("jakarta.validation.ConstraintViolationException"), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.jackson.JsonProcessingExceptionMapper").thatHandles("com.fasterxml.jackson.core.JsonProcessingException").onlyIf(new JacksonDetector()), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.jackson.UnrecognizedPropertyExceptionMapper").thatHandles("com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException").onlyIf(new JacksonDetector()), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.jackson.InvalidFormatExceptionMapper").thatHandles("com.fasterxml.jackson.databind.exc.InvalidFormatException").onlyIf(new JacksonDetector()), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.jsonb.RestEasyClassicJsonbExceptionMapper").thatHandles("jakarta.ws.rs.ProcessingException").onlyIf(new JsonBDetector()), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.jsonb.JsonbExceptionMapper").thatHandles("jakarta.json.bind.JsonbException").onlyIf(new JsonBDetector()), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.ZalandoProblemMapper").thatHandles("org.zalando.problem.ThrowableProblem"), ExceptionMapperDefinition.mapper("io.quarkiverse.resteasy.problem.DefaultExceptionMapper").thatHandles("java.lang.Exception"));
        return allMappers.filter(ExceptionMapperDefinition::isNeeded).collect(Collectors.toList());
    }

    @BuildStep
    FeatureBuildItem createFeature(Capabilities capabilities) {
        if (RESTEASY_JSON_CAPABILITIES.stream().noneMatch(arg_0 -> ((Capabilities)capabilities).isPresent(arg_0))) {
            this.logger().error("`quarkus-resteasy-problem` extension is useless without RESTeasy Json Provider. Please add `quarkus-resteasy-jackson` or `quarkus-resteasy-jsonb` (or reactive versions) to your pom.xml.");
        }
        return new FeatureBuildItem(FEATURE_NAME);
    }

    @BuildStep(onlyIf={RestEasyClassicDetector.class})
    void registerMappersForClassic(BuildProducer<ResteasyJaxrsProviderBuildItem> providers) {
        ProblemProcessor.neededExceptionMappers().forEach(mapper -> providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(mapper.mapperClassName)));
    }

    @BuildStep(onlyIf={RestEasyReactiveDetector.class})
    void registerMappersForReactive(BuildProducer<ExceptionMapperBuildItem> providers) {
        ProblemProcessor.neededExceptionMappers().forEach(mapper -> providers.produce((BuildItem)new ExceptionMapperBuildItem(mapper.mapperClassName, mapper.exceptionClassName, Integer.valueOf(999), true)));
    }

    @BuildStep(onlyIf={RestEasyReactiveDetector.class})
    void registerCustomExceptionMappers(BuildProducer<CustomExceptionMapperBuildItem> customExceptionMapper) {
        customExceptionMapper.produce((BuildItem)new CustomExceptionMapperBuildItem("io.quarkiverse.resteasy.problem.security.UnauthorizedExceptionReactiveMapper"));
        customExceptionMapper.produce((BuildItem)new CustomExceptionMapperBuildItem("io.quarkiverse.resteasy.problem.security.AuthenticationFailedExceptionReactiveMapper"));
    }

    @BuildStep(onlyIf={JacksonDetector.class})
    void registerJacksonItems(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{"io.quarkiverse.resteasy.problem.jackson.JacksonProblemModuleRegistrar"}));
    }

    @BuildStep(onlyIf={JsonBDetector.class})
    void registerJsonbItems(BuildProducer<JsonbSerializerBuildItem> serializers, BuildProducer<JsonbDeserializerBuildItem> deserializers) {
        serializers.produce((BuildItem)new JsonbSerializerBuildItem("io.quarkiverse.resteasy.problem.jsonb.JsonbProblemSerializer"));
        deserializers.produce((BuildItem)new JsonbDeserializerBuildItem("io.quarkiverse.resteasy.problem.jsonb.JsonbProblemDeserializer"));
    }

    @BuildStep(onlyIf={OpenApiDetector.class})
    void indexOpenApiClasses(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("io.quarkiverse.resteasy-problem", "quarkus-resteasy-problem"));
    }

    @BuildStep(onlyIf={OpenApiDetector.class})
    void registerOpenApiFilter(BuildProducer<AddToOpenAPIDefinitionBuildItem> openAPIProducer, ProblemBuildConfig config) {
        OpenApiProblemFilter filter = new OpenApiProblemFilter(config);
        openAPIProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem((OASFilter)filter));
    }

    @BuildStep
    ReflectiveClassBuildItem registerPojosForReflection() {
        return ReflectiveClassBuildItem.builder((String[])new String[]{"io.quarkiverse.resteasy.problem.validation.Violation"}).methods().fields().build();
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void resetRecorder(ProblemRecorder recorder, LiveReloadBuildItem liveReload) {
        if (liveReload.isLiveReload()) {
            recorder.reset();
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void setupMdc(ProblemRecorder recorder, ProblemBuildConfig config) {
        recorder.configureMdc(config.includeMdcProperties());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={QuarkusSmallryeMetricsDetector.class})
    void setupMetrics(ProblemRecorder recorder, ProblemBuildConfig config) {
        if (config.metricsEnabled()) {
            recorder.enableMetrics();
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void registerCustomPostProcessors(ProblemRecorder recorder) {
        recorder.registerCustomPostProcessors();
    }

    @BuildStep
    UnremovableBeanBuildItem markPostProcessorsUnremovable() {
        return UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{ProblemPostProcessor.class});
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void applyRuntimeConfig(ProblemRecorder recorder, ProblemRuntimeConfig config) {
        recorder.applyRuntimeConfig(config);
    }

    protected Logger logger() {
        return LoggerFactory.getLogger((String)FEATURE_NAME);
    }
}

