/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.resteasy.problem.postprocessing;

import io.quarkiverse.resteasy.problem.HttpProblem;
import io.quarkiverse.resteasy.problem.postprocessing.ProblemContext;
import io.quarkiverse.resteasy.problem.postprocessing.ProblemPostProcessor;
import java.util.Collections;
import java.util.Set;
import org.slf4j.MDC;

final class MdcPropertiesInjector
implements ProblemPostProcessor {
    private final Set<String> properties;

    public MdcPropertiesInjector(Set<String> properties) {
        this.properties = Collections.unmodifiableSet(properties);
    }

    @Override
    public int priority() {
        return 100;
    }

    @Override
    public HttpProblem apply(HttpProblem problem, ProblemContext context) {
        if (this.properties.isEmpty()) {
            return problem;
        }
        HttpProblem.Builder builder = HttpProblem.builder(problem);
        this.properties.stream().filter(propertyName -> !problem.getParameters().containsKey(propertyName)).filter(propertyName -> MDC.get((String)propertyName) != null).forEach(propertyName -> builder.with((String)propertyName, MDC.get((String)propertyName)));
        return builder.build();
    }
}

