/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.resteasy.problem.postprocessing;

import io.quarkiverse.resteasy.problem.ExceptionMapperBase;
import io.quarkiverse.resteasy.problem.ProblemRuntimeConfig;
import io.quarkiverse.resteasy.problem.postprocessing.MdcPropertiesInjector;
import io.quarkiverse.resteasy.problem.postprocessing.MicroprofileMetricsCollector;
import io.quarkiverse.resteasy.problem.postprocessing.ProblemPostProcessor;
import io.quarkiverse.resteasy.problem.validation.ConstraintViolationExceptionMapper;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Set;

@Recorder
public class ProblemRecorder {
    public void reset() {
        ExceptionMapperBase.postProcessorsRegistry.reset();
    }

    public void configureMdc(Set<String> includeMdcProperties) {
        if (!includeMdcProperties.isEmpty()) {
            ExceptionMapperBase.postProcessorsRegistry.register(new MdcPropertiesInjector(includeMdcProperties));
        }
    }

    public void enableMetrics() {
        ExceptionMapperBase.postProcessorsRegistry.register(new MicroprofileMetricsCollector());
    }

    public void registerCustomPostProcessors() {
        CDI.current().select(ProblemPostProcessor.class, new Annotation[0]).forEach(ExceptionMapperBase.postProcessorsRegistry::register);
    }

    public void applyRuntimeConfig(ProblemRuntimeConfig config) {
        ConstraintViolationExceptionMapper.configure(config.constraintViolation());
    }
}

