/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.resteasy.problem.security;

import io.quarkiverse.resteasy.problem.ExceptionMapperBase;
import io.quarkiverse.resteasy.problem.HttpProblem;
import io.quarkiverse.resteasy.problem.security.HttpUnauthorizedUtils;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;

@Priority(value=5000)
public final class UnauthorizedExceptionMapper
extends ExceptionMapperBase<UnauthorizedException> {
    volatile CurrentVertxRequest currentVertxRequest;

    @Override
    protected HttpProblem toProblem(UnauthorizedException exception) {
        return (HttpProblem)HttpUnauthorizedUtils.toProblem(this.currentVertxRequest().getCurrent(), (Exception)exception).await().indefinitely();
    }

    private CurrentVertxRequest currentVertxRequest() {
        if (this.currentVertxRequest == null) {
            this.currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
        }
        return this.currentVertxRequest;
    }
}

