/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.resteasy.problem.postprocessing;

import io.quarkiverse.resteasy.problem.HttpProblem;
import io.quarkiverse.resteasy.problem.postprocessing.ProblemContext;
import io.quarkiverse.resteasy.problem.postprocessing.ProblemPostProcessor;
import io.smallrye.metrics.MetricRegistries;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

final class MicroprofileMetricsCollector
implements ProblemPostProcessor {
    private static final String METRIC_NAME = "http.error";
    private static final String METRIC_DESCRIPTION = "The number of http errors returned since the start of the server.";
    private static final String STATUS_TAG = "status";
    private final MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.APPLICATION);

    public MicroprofileMetricsCollector() {
        this.initTagMetadata();
    }

    private void initTagMetadata() {
        if (!this.registry.getMetadata().containsKey(METRIC_NAME)) {
            Metadata metadata = Metadata.builder().withName(METRIC_NAME).withDescription(METRIC_DESCRIPTION).build();
            Tag tag = new Tag(STATUS_TAG, "500");
            this.registry.counter(metadata, new Tag[]{tag});
        }
    }

    @Override
    public int priority() {
        return 100;
    }

    @Override
    public HttpProblem apply(HttpProblem problem, ProblemContext context) {
        Tag tag = new Tag(STATUS_TAG, String.valueOf(problem.getStatusCode()));
        this.registry.counter(METRIC_NAME, new Tag[]{tag}).inc();
        return problem;
    }
}

