/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.resteasy.problem.jaxrs;

import io.quarkiverse.resteasy.problem.ExceptionMapperBase;
import io.quarkiverse.resteasy.problem.HttpProblem;
import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Optional;

@Priority(value=5000)
public final class WebApplicationExceptionMapper
extends ExceptionMapperBase<WebApplicationException> {
    @Override
    protected HttpProblem toProblem(WebApplicationException exception) {
        Response.StatusType status = exception.getResponse().getStatusInfo();
        HttpProblem.Builder problem = HttpProblem.builder().withTitle(status.getReasonPhrase()).withStatus(status).withDetail(exception.getMessage());
        Optional.ofNullable(exception.getResponse().getHeaders()).ifPresent(headers -> headers.forEach((header, values) -> values.forEach(value -> problem.withHeader((String)header, value))));
        return problem.build();
    }
}

