/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.resteasy.problem.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.quarkiverse.resteasy.problem.HttpProblem;
import java.io.IOException;
import java.net.URI;
import java.util.Map;

public final class JacksonProblemDeserializer
extends StdDeserializer<HttpProblem> {
    private final ObjectMapper mapper;

    public JacksonProblemDeserializer(ObjectMapper mapper) {
        super((Class)null);
        this.mapper = mapper;
    }

    public HttpProblem deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Map rawDeserializedProblem = (Map)this.mapper.readValue(jsonParser, (TypeReference)new TypeReference<Map<String, Object>>(){});
        HttpProblem.Builder builder = HttpProblem.builder();
        block14: for (String fieldName : rawDeserializedProblem.keySet()) {
            Object child = rawDeserializedProblem.get(fieldName);
            switch (fieldName) {
                case "type": {
                    builder.withType(this.uriOrThrow(child, fieldName, jsonParser));
                    continue block14;
                }
                case "status": {
                    builder.withStatus(this.intOrThrow(child, fieldName, jsonParser));
                    continue block14;
                }
                case "title": {
                    builder.withTitle((String)child);
                    continue block14;
                }
                case "detail": {
                    builder.withDetail((String)child);
                    continue block14;
                }
                case "instance": {
                    builder.withInstance(this.uriOrThrow(child, fieldName, jsonParser));
                    continue block14;
                }
            }
            builder.with(fieldName, child);
        }
        return builder.build();
    }

    private URI uriOrThrow(Object child, String fieldName, JsonParser jsonParser) throws JsonMappingException {
        try {
            return URI.create((String)child);
        }
        catch (IllegalArgumentException e) {
            throw JsonMappingException.from((JsonParser)jsonParser, (String)"'%s' field must be a valid URI".formatted(fieldName));
        }
    }

    private int intOrThrow(Object child, String fieldName, JsonParser jsonParser) throws JsonMappingException {
        try {
            return (Integer)child;
        }
        catch (ClassCastException e) {
            throw JsonMappingException.from((JsonParser)jsonParser, (String)"'%s' field must be a valid http status code".formatted(fieldName));
        }
    }
}

