/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.resteasy.problem.jsonb;

import io.quarkiverse.resteasy.problem.HttpProblem;
import jakarta.json.bind.JsonbException;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Map;

public final class JsonbProblemDeserializer
implements JsonbDeserializer<HttpProblem> {
    public HttpProblem deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Type type) {
        Map rawDeserializedProblem = (Map)deserializationContext.deserialize(Map.class, jsonParser);
        HttpProblem.Builder builder = HttpProblem.builder();
        block14: for (String fieldName : rawDeserializedProblem.keySet()) {
            Object child = rawDeserializedProblem.get(fieldName);
            switch (fieldName) {
                case "type": {
                    builder.withType(this.uriOrThrow(child, fieldName));
                    continue block14;
                }
                case "status": {
                    builder.withStatus(this.intOrThrow(child, fieldName));
                    continue block14;
                }
                case "title": {
                    builder.withTitle((String)child);
                    continue block14;
                }
                case "detail": {
                    builder.withDetail((String)child);
                    continue block14;
                }
                case "instance": {
                    builder.withInstance(this.uriOrThrow(child, fieldName));
                    continue block14;
                }
            }
            builder.with(fieldName, child);
        }
        return builder.build();
    }

    private URI uriOrThrow(Object child, String fieldName) {
        try {
            return URI.create((String)child);
        }
        catch (IllegalArgumentException e) {
            throw new JsonbException("'%s' field must be a valid URI".formatted(fieldName));
        }
    }

    private int intOrThrow(Object child, String fieldName) {
        try {
            return ((BigDecimal)child).intValue();
        }
        catch (ClassCastException e) {
            throw new JsonbException("'%s' field must be a valid http status code".formatted(fieldName));
        }
    }
}

