/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.resteasy.problem.postprocessing;

import io.quarkiverse.resteasy.problem.HttpProblem;
import io.quarkiverse.resteasy.problem.postprocessing.ProblemContext;
import io.quarkiverse.resteasy.problem.postprocessing.ProblemPostProcessor;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

final class ProblemLogger
implements ProblemPostProcessor {
    private final Logger logger;

    ProblemLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public HttpProblem apply(HttpProblem problem, ProblemContext context) {
        if (!this.logger.isErrorEnabled()) {
            return problem;
        }
        if (problem.getStatusCode() >= 500) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(this.serialize(problem), context.cause);
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info(this.serialize(problem));
        }
        return problem;
    }

    private String serialize(HttpProblem problem) {
        Stream<String> basicFields = Stream.of("status=" + problem.getStatusCode(), problem.getTitle() == null ? null : "title=\"" + problem.getTitle() + "\"", problem.getDetail() == null ? null : "detail=\"" + problem.getDetail() + "\"", problem.getInstance() == null ? null : "instance=\"" + String.valueOf(problem.getInstance()) + "\"", problem.getType() == null ? null : "type=" + problem.getType().toString());
        Stream<String> parameters = problem.getParameters().entrySet().stream().map(this::serializeParameter);
        return Stream.concat(basicFields, parameters).filter(Objects::nonNull).collect(Collectors.joining(", "));
    }

    private String serializeParameter(Map.Entry<String, Object> param) {
        String serializedValue = Optional.ofNullable(param.getValue()).map(value -> {
            if (value instanceof String) {
                return "\"" + String.valueOf(value) + "\"";
            }
            return value.toString();
        }).orElse("null");
        return param.getKey() + "=" + serializedValue;
    }

    @Override
    public int priority() {
        return 101;
    }
}

