/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.resteasy.problem.security;

import io.quarkiverse.resteasy.problem.ExceptionMapperBase;
import io.quarkiverse.resteasy.problem.HttpProblem;
import io.quarkiverse.resteasy.problem.postprocessing.ProblemContext;
import io.quarkiverse.resteasy.problem.security.HttpUnauthorizedUtils;
import io.quarkus.security.AuthenticationFailedException;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.ws.rs.core.Response;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;

public final class AuthenticationFailedExceptionReactiveMapper {
    @ServerExceptionMapper(value={AuthenticationFailedException.class}, priority=4999)
    public Uni<Response> handle(RoutingContext routingContext, AuthenticationFailedException exception) {
        return HttpUnauthorizedUtils.toProblem(routingContext, (Exception)exception).map(problem -> {
            ProblemContext context = ProblemContext.of((Throwable)exception, routingContext.normalizedPath());
            HttpProblem finalProblem = ExceptionMapperBase.postProcessorsRegistry.applyPostProcessing((HttpProblem)problem, context);
            return finalProblem.toResponse();
        });
    }
}

