/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.resteasy.problem.security;

import io.quarkiverse.resteasy.problem.ExceptionMapperBase;
import io.quarkiverse.resteasy.problem.HttpProblem;
import io.quarkiverse.resteasy.problem.security.HttpUnauthorizedUtils;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;

@Priority(value=5000)
@APIResponse(responseCode="401", description="Unauthorized: request was not successful because it lacks valid authentication credentials for the requested resource")
public final class UnauthorizedExceptionMapper
extends ExceptionMapperBase<UnauthorizedException>
implements ExceptionMapper<UnauthorizedException> {
    volatile CurrentVertxRequest currentVertxRequest;

    @Override
    protected HttpProblem toProblem(UnauthorizedException exception) {
        return (HttpProblem)HttpUnauthorizedUtils.toProblem(this.currentVertxRequest().getCurrent(), (Exception)exception).await().indefinitely();
    }

    private CurrentVertxRequest currentVertxRequest() {
        if (this.currentVertxRequest == null) {
            this.currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
        }
        return this.currentVertxRequest;
    }
}

