/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.resteasy.problem.validation;

import org.eclipse.microprofile.openapi.annotations.media.Schema;

@Schema(name="Violation", description="Validation constraint violation details")
public final class Violation {
    @Schema(description="The field for which the validation failed", examples={"#/profile/email"})
    public final String field;
    @Schema(description="Part of the http request where the validation error occurred such as query, path, header, form, body", examples={"query", "path", "header", "form", "body"})
    public final String in;
    @Schema(description="Description of the validation error", examples={"Invalid email format"})
    public final String message;

    private Violation(String field, String in, String message) {
        this.field = field;
        this.in = in;
        this.message = message;
    }

    public String toString() {
        return "Violation{field='" + this.field + "', in='" + this.in + "', message='" + this.message + "'}";
    }

    public static interface MessageSupplier {
        public Violation message(String var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum In {
        query,
        path,
        header,
        form,
        body,
        unknown{

            @Override
            protected String serialize() {
                return "?";
            }
        };


        public MessageSupplier field(String field) {
            return message -> new Violation(field, this.serialize(), message);
        }

        protected String serialize() {
            return this.name();
        }
    }
}

