/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.resteasy.problem.postprocessing;

import io.quarkiverse.resteasy.problem.HttpProblem;
import io.quarkiverse.resteasy.problem.postprocessing.ProblemContext;
import io.quarkiverse.resteasy.problem.postprocessing.ProblemDefaultsProvider;
import io.quarkiverse.resteasy.problem.postprocessing.ProblemLogger;
import io.quarkiverse.resteasy.problem.postprocessing.ProblemPostProcessor;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.LoggerFactory;

public final class PostProcessorsRegistry {
    private final List<ProblemPostProcessor> processors = new CopyOnWriteArrayList<ProblemPostProcessor>();

    public PostProcessorsRegistry() {
        this.reset();
    }

    public synchronized void reset() {
        this.processors.clear();
        this.register(new ProblemLogger(LoggerFactory.getLogger((String)"http-problem")));
        this.register(new ProblemDefaultsProvider());
    }

    public synchronized void register(ProblemPostProcessor processor) {
        this.processors.add(processor);
        this.processors.sort(ProblemPostProcessor.DEFAULT_ORDERING);
    }

    public HttpProblem applyPostProcessing(HttpProblem problem, ProblemContext context) {
        HttpProblem finalProblem = problem;
        for (ProblemPostProcessor processor : this.processors) {
            finalProblem = processor.apply(finalProblem, context);
        }
        return finalProblem;
    }
}

