/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.resteasy.problem.validation;

public final class Violation {
    public final String field;
    public final String in;
    public final String message;

    private Violation(String field, String in, String message) {
        this.field = field;
        this.in = in;
        this.message = message;
    }

    public String toString() {
        return "Violation{field='" + this.field + "', in='" + this.in + "', message='" + this.message + "'}";
    }

    public static interface MessageSupplier {
        public Violation message(String var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum In {
        query,
        path,
        header,
        form,
        body,
        unknown{

            @Override
            protected String serialize() {
                return "?";
            }
        };


        public MessageSupplier field(String field) {
            return message -> new Violation(field, this.serialize(), message);
        }

        protected String serialize() {
            return this.name();
        }
    }
}

