/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.deployment;

import io.quarkiverse.roq.deployment.config.RoqConfig;
import io.quarkiverse.roq.deployment.items.RoqProjectBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.jboss.logging.Logger;

public class RoqProjectProcessor {
    private static final Logger LOG = Logger.getLogger(RoqProjectProcessor.class);

    @BuildStep
    RoqProjectBuildItem findProject(RoqConfig config, OutputTargetBuildItem outputTarget) {
        String resourceDir;
        RoqProjectBuildItem.RoqProject project = RoqProjectProcessor.resolveProjectDirs(config, outputTarget);
        try {
            boolean hasResourceDir = config.resourceDir().isEmpty() || Thread.currentThread().getContextClassLoader().getResources(config.resourceDir()).hasMoreElements();
            resourceDir = hasResourceDir ? config.resourceDir() : null;
        }
        catch (IOException e) {
            resourceDir = null;
        }
        RoqProjectBuildItem roqProject = new RoqProjectBuildItem(project, resourceDir);
        if (!roqProject.isActive()) {
            LOG.warn((Object)"Not Roq site directory found. It is recommended to remove the quarkus-roq extension if not used.");
        }
        return roqProject;
    }

    private static RoqProjectBuildItem.RoqProject resolveProjectDirs(RoqConfig config, OutputTargetBuildItem outputTarget) {
        Path siteRoot;
        Path projectRoot = RoqProjectProcessor.findProjectRoot(outputTarget.getOutputDirectory());
        Path configuredSiteDirPath = Paths.get(config.dir().trim(), new String[0]);
        if (projectRoot == null || !Files.isDirectory(projectRoot, new LinkOption[0])) {
            if (configuredSiteDirPath.isAbsolute() && Files.isDirectory(configuredSiteDirPath, new LinkOption[0])) {
                configuredSiteDirPath = configuredSiteDirPath.normalize();
            } else {
                LOG.warn((Object)"If not absolute, the Site directory is resolved relative to the project root, but Roq was not able to find the project root.");
                return null;
            }
        }
        if (!Files.isDirectory(siteRoot = Objects.requireNonNull(projectRoot).resolve(configuredSiteDirPath).normalize(), new LinkOption[0])) {
            return null;
        }
        return new RoqProjectBuildItem.RoqProject(projectRoot, siteRoot);
    }

    private static Path findProjectRoot(Path outputDirectory) {
        Path currentPath = outputDirectory;
        while (true) {
            if (Files.exists(currentPath.resolve(Paths.get("src", "main")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.properties")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.yaml")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.yml")), new LinkOption[0])) {
                return currentPath.normalize();
            }
            if (currentPath.getParent() == null || !Files.exists(currentPath.getParent(), new LinkOption[0])) break;
            currentPath = currentPath.getParent();
        }
        return null;
    }
}

