/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.deployment;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.quarkiverse.roq.deployment.config.RoqJacksonConfig;
import io.quarkiverse.roq.deployment.items.RoqJacksonBuildItem;
import io.quarkus.arc.impl.Reflections;
import io.quarkus.deployment.annotations.BuildStep;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;

public class RoqJacksonProcessor {
    @BuildStep
    RoqJacksonBuildItem findProject(RoqJacksonConfig jacksonConfig) {
        Optional<PropertyNamingStrategy> propertyNamingStrategy;
        YAMLMapper.Builder yamlMapperBuilder = YAMLMapper.builder();
        JsonMapper.Builder jsonMapperBuilder = JsonMapper.builder();
        if (!jacksonConfig.failOnUnknownProperties()) {
            yamlMapperBuilder.disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
            jsonMapperBuilder.disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
        }
        if (!jacksonConfig.failOnEmptyBeans()) {
            yamlMapperBuilder.disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS});
            jsonMapperBuilder.disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS});
        }
        if (jacksonConfig.acceptCaseInsensitiveEnums()) {
            yamlMapperBuilder.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
            jsonMapperBuilder.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        }
        if ((propertyNamingStrategy = this.determinePropertyNamingStrategyClassName(jacksonConfig)).isPresent()) {
            jsonMapperBuilder.propertyNamingStrategy(propertyNamingStrategy.get());
            yamlMapperBuilder.propertyNamingStrategy(propertyNamingStrategy.get());
        }
        return new RoqJacksonBuildItem((JsonMapper)jsonMapperBuilder.build(), (YAMLMapper)yamlMapperBuilder.build());
    }

    private Optional<PropertyNamingStrategy> determinePropertyNamingStrategyClassName(RoqJacksonConfig jacksonConfig) {
        Field field;
        if (jacksonConfig.propertyNamingStrategy().isEmpty()) {
            return Optional.empty();
        }
        String propertyNamingStrategy = jacksonConfig.propertyNamingStrategy().get();
        try {
            field = Reflections.findField(PropertyNamingStrategies.class, (String)propertyNamingStrategy);
        }
        catch (Exception e) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(propertyNamingStrategy);
                if (PropertyNamingStrategy.class.isAssignableFrom(clazz)) {
                    return Optional.of((PropertyNamingStrategy)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                throw new RuntimeException(RoqJacksonProcessor.invalidPropertyNameStrategyValueMessage(propertyNamingStrategy));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new RuntimeException(RoqJacksonProcessor.invalidPropertyNameStrategyValueMessage(propertyNamingStrategy));
            }
        }
        try {
            Object value = field.get(null);
            Class<?> clazz = value.getClass();
            if (PropertyNamingStrategy.class.isAssignableFrom(clazz)) {
                return Optional.of((PropertyNamingStrategy)value);
            }
            throw new RuntimeException(RoqJacksonProcessor.invalidPropertyNameStrategyValueMessage(propertyNamingStrategy));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(RoqJacksonProcessor.invalidPropertyNameStrategyValueMessage(propertyNamingStrategy));
        }
    }

    private static String invalidPropertyNameStrategyValueMessage(String propertyNamingStrategy) {
        return "Unable to determine the property naming strategy for value '" + propertyNamingStrategy + "'. Make sure that the value is either a fully qualified class name of a subclass of '" + PropertyNamingStrategy.class.getName() + "' or one of the constants defined in '" + PropertyNamingStrategies.class.getName() + "'.";
    }
}

