/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.deployment.items;

import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.paths.PathVisit;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;

public final class RoqProjectBuildItem
extends SimpleBuildItem {
    private final RoqProject project;
    private final String roqResourceDir;

    public RoqProjectBuildItem(RoqProject project, String roqResourceDir) {
        this.project = project;
        this.roqResourceDir = roqResourceDir;
    }

    public RoqProject project() {
        return this.project;
    }

    public boolean isActive() {
        return this.project != null || this.roqResourceDir != null;
    }

    public void consumePathFromRoqResourceDir(String resource, Consumer<PathVisit> consumer) throws IOException {
        if (this.roqResourceDir != null) {
            RoqProjectBuildItem.visitRuntimeResources(PathUtils.join((String)this.roqResourceDir, (String)resource), consumer);
        }
    }

    public void consumePathFromRoqDir(String resource, Consumer<Path> consumer) throws IOException {
        if (this.project != null) {
            consumer.accept(this.project.roqDir().resolve(resource));
        }
    }

    public void consumeRoqResourceDir(Consumer<PathVisit> consumer) throws IOException {
        if (this.roqResourceDir != null) {
            RoqProjectBuildItem.visitRuntimeResources(this.roqResourceDir, consumer);
        }
    }

    public void consumeRoqDir(Consumer<Path> consumer) throws IOException {
        if (this.project != null) {
            consumer.accept(this.project.roqDir());
        }
    }

    public boolean isRoqResourcesInRoot() {
        return this.roqResourceDir != null && this.roqResourceDir.isEmpty();
    }

    public String roqResourceDir() {
        return this.roqResourceDir;
    }

    public static void visitRuntimeResources(String resourceName, Consumer<PathVisit> visitor) {
        HashSet visited = new HashSet();
        QuarkusClassLoader.visitRuntimeResources((String)resourceName, (T p) -> {
            if (visited.add(p.getUrl().toExternalForm())) {
                visitor.accept((PathVisit)p);
            }
        });
    }

    public record RoqProject(Path rootDir, Path roqDir) {
    }
}

