/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.data.deployment.converters;

import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.quarkiverse.roq.data.deployment.DataConverter;
import io.quarkiverse.roq.data.deployment.converters.JsonConverter;
import io.quarkiverse.roq.data.deployment.converters.YamlConverter;
import java.util.Map;

public final class DataConverterFinder {
    private final Map<String, DataConverter> converterByExtension;

    public DataConverterFinder(JsonMapper jsonMapper, YAMLMapper yamlMapper) {
        JsonConverter jsonConverter = new JsonConverter(jsonMapper);
        YamlConverter yamlConverter = new YamlConverter(yamlMapper);
        this.converterByExtension = Map.of("yaml", yamlConverter, "yml", yamlConverter, "json", jsonConverter);
    }

    public DataConverter fromFileName(String fileName) {
        if (!fileName.contains(".")) {
            return null;
        }
        String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
        return this.converterByExtension.get(extension);
    }
}

