/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.data.deployment.converters;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.quarkiverse.roq.data.deployment.DataConverter;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class YamlConverter
implements DataConverter {
    private final YAMLMapper mapper;

    public YamlConverter(YAMLMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Object convert(byte[] content) throws IOException {
        JsonNode rootNode = this.mapper.readTree(content);
        if (rootNode.isObject()) {
            return new JsonObject((Map)this.mapper.convertValue((Object)rootNode, Map.class));
        }
        if (rootNode.isArray()) {
            return new JsonArray((List)this.mapper.convertValue((Object)rootNode, List.class));
        }
        throw new IllegalStateException("Unsupported YAML root element type: " + String.valueOf(rootNode.getNodeType()));
    }

    @Override
    public <T> T convertToType(byte[] content, Class<T> clazz) throws IOException {
        JavaType javaType = this.mapper.getTypeFactory().constructType(clazz);
        return (T)this.mapper.readValue(content, javaType);
    }

    @Override
    public <T> List<T> convertToTypedList(byte[] content, Class<T> clazz) throws IOException {
        CollectionType collectionType = this.mapper.getTypeFactory().constructCollectionType(List.class, clazz);
        return (List)this.mapper.readValue(content, (JavaType)collectionType);
    }
}

