/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.data.deployment.items;

import io.quarkiverse.roq.data.deployment.DataConverter;
import io.quarkus.builder.item.MultiBuildItem;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;

public final class RoqDataBuildItem
extends MultiBuildItem {
    private final String name;
    private final Path sourceFile;
    private final byte[] content;
    private final DataConverter converter;

    public RoqDataBuildItem(String name, Path sourceFile, byte[] content, DataConverter converter) {
        this.name = name;
        this.sourceFile = sourceFile;
        this.content = content;
        this.converter = converter;
    }

    public Path sourceFile() {
        return this.sourceFile;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getContent() {
        return this.content;
    }

    public Object convert() throws IOException {
        return this.converter.convert(this.content);
    }

    public DataConverter converter() {
        return this.converter;
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RoqDataBuildItem that = (RoqDataBuildItem)((Object)o);
        return Objects.equals(this.name, that.name) && Objects.equals(this.sourceFile, that.sourceFile) && Objects.deepEquals(this.content, that.content) && Objects.equals(this.converter, that.converter);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.sourceFile, Arrays.hashCode(this.content), this.converter);
    }
}

