/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.data.deployment;

import io.quarkiverse.roq.data.deployment.RoqDataConfig;
import io.quarkiverse.roq.data.deployment.items.RoqDataBeanBuildItem;
import io.quarkiverse.roq.data.deployment.items.RoqDataJsonBuildItem;
import io.quarkiverse.roq.data.runtime.RoqDataRecorder;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;

class RoqDataBeanProcessor {
    private static final String FEATURE = "roq-data";
    private static final Logger LOG = Logger.getLogger(RoqDataBeanProcessor.class);

    RoqDataBeanProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void generateSyntheticBeans(RoqDataConfig config, BuildProducer<SyntheticBeanBuildItem> beansProducer, List<RoqDataJsonBuildItem> roqDataJsonBuildItems, List<RoqDataBeanBuildItem> dataBeanBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, RoqDataRecorder recorder) {
        reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{JsonObject.class}).serialization().constructors().fields().methods().build());
        ArrayList<String> beans = new ArrayList<String>(roqDataJsonBuildItems.size());
        for (RoqDataJsonBuildItem roqData : roqDataJsonBuildItems) {
            Class<JsonObject> cl;
            if (roqData.getData() instanceof JsonObject) {
                cl = JsonObject.class;
            } else if (roqData.getData() instanceof JsonArray) {
                cl = JsonArray.class;
            } else {
                throw new IllegalStateException("Unsupported Json data bean type for %s".formatted(roqData.getName()));
            }
            beansProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(cl).scope(ApplicationScoped.class)).named(roqData.getName())).runtimeValue(recorder.createRoqDataJson(roqData.getData())).unremovable()).done());
            beans.add("    - %s[name=%s]*".formatted(cl.getName(), roqData.getName()));
        }
        for (RoqDataBeanBuildItem beanBuildItem : dataBeanBuildItems) {
            reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{beanBuildItem.getBeanClass()}).serialization().constructors().fields().methods().build());
            beansProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(beanBuildItem.getBeanClass()).scope(beanBuildItem.isRecord() ? Singleton.class : ApplicationScoped.class)).named(beanBuildItem.getName())).runtimeValue(recorder.createRoqDataJson(beanBuildItem.getData())).unremovable()).done());
            beans.add("    - %s[name=%s]".formatted(beanBuildItem.getBeanClass().getName(), beanBuildItem.getName()));
        }
        if (!beans.isEmpty() && config.logDataBeans()) {
            LOG.infof("Roq data beans%s: %n%s", (Object)(roqDataJsonBuildItems.isEmpty() ? "" : " (* add a @DataMapping to enable type-safety)"), (Object)String.join((CharSequence)System.lineSeparator(), beans));
        }
    }
}

