/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.data.deployment.converters;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import io.quarkiverse.roq.data.deployment.DataConverter;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import java.io.IOException;
import java.util.List;

public class JsonConverter
implements DataConverter {
    private final JsonMapper mapper;

    public JsonConverter(JsonMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Object convert(byte[] content) {
        return Json.decodeValue((Buffer)Buffer.buffer((byte[])content));
    }

    @Override
    public <T> T convertToType(byte[] content, Class<T> clazz) throws IOException {
        JavaType javaType = this.mapper.getTypeFactory().constructType(clazz);
        return (T)this.mapper.readValue(content, javaType);
    }

    @Override
    public <T> List<T> convertToTypedList(byte[] content, Class<T> clazz) throws IOException {
        CollectionType collectionType = this.mapper.getTypeFactory().constructCollectionType(List.class, clazz);
        return (List)this.mapper.readValue(content, (JavaType)collectionType);
    }
}

