/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.data.deployment;

import io.quarkiverse.roq.data.deployment.DataConverter;
import io.quarkiverse.roq.data.deployment.RoqDataConfig;
import io.quarkiverse.roq.data.deployment.converters.DataConverterFinder;
import io.quarkiverse.roq.data.deployment.exception.DataConflictException;
import io.quarkiverse.roq.data.deployment.exception.DataConversionException;
import io.quarkiverse.roq.data.deployment.exception.DataMappingMismatchException;
import io.quarkiverse.roq.data.deployment.exception.DataMappingRequiredFileException;
import io.quarkiverse.roq.data.deployment.exception.DataScanningException;
import io.quarkiverse.roq.data.deployment.items.DataMappingBuildItem;
import io.quarkiverse.roq.data.deployment.items.RoqDataBuildItem;
import io.quarkiverse.roq.data.deployment.items.RoqDataJsonBuildItem;
import io.quarkiverse.roq.data.runtime.annotations.DataMapping;
import io.quarkiverse.roq.deployment.items.RoqJacksonBuildItem;
import io.quarkiverse.roq.deployment.items.RoqProjectBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class RoqDataReaderProcessor {
    private static final Set<String> SUPPORTED_EXTENSIONS = Set.of(".json", ".yaml", ".yml");
    private static final Logger LOG = Logger.getLogger(RoqDataReaderProcessor.class);
    private static final DotName DATA_MAPPING_ANNOTATION = DotName.createSimple((String)DataMapping.class.getName());
    RoqDataConfig roqDataConfig;

    @BuildStep
    void scanDataFiles(RoqProjectBuildItem roqProject, RoqDataConfig config, RoqJacksonBuildItem jackson, BuildProducer<RoqDataBuildItem> dataProducer, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFilesProducer) {
        if (roqProject.isActive()) {
            DataConverterFinder converter = new DataConverterFinder(jackson.getJsonMapper(), jackson.getYamlMapper());
            try {
                Collection<RoqDataBuildItem> items = this.scanDataFiles(roqProject, converter, watchedFilesProducer, config);
                for (RoqDataBuildItem item : items) {
                    dataProducer.produce((BuildItem)item);
                }
            }
            catch (IOException e) {
                throw new DataScanningException("Unable to scan data files", e);
            }
        }
    }

    @BuildStep
    AdditionalIndexedClassesBuildItem addAnnotation() {
        return new AdditionalIndexedClassesBuildItem(DATA_MAPPING_ANNOTATION.toString());
    }

    @BuildStep
    void scanDataMappings(CombinedIndexBuildItem index, List<RoqDataBuildItem> roqDataBuildItems, BuildProducer<DataMappingBuildItem> dataMappingProducer, BuildProducer<RoqDataJsonBuildItem> dataJsonProducer, RoqDataConfig config) {
        List<String> dataMappingErrors;
        Collection annotations = index.getIndex().getAnnotations(DATA_MAPPING_ANNOTATION);
        Map dataJsonMap = roqDataBuildItems.stream().collect(Collectors.toMap(RoqDataBuildItem::getName, Function.identity()));
        Map annotationMap = annotations.stream().collect(Collectors.toMap(annotation -> annotation.value().asString(), Function.identity()));
        annotationMap.forEach((key, annotationInstance) -> {
            boolean isRequired = Optional.ofNullable(annotationInstance.value("required")).map(AnnotationValue::asBoolean).orElse(false);
            if (isRequired && !dataJsonMap.containsKey(key)) {
                throw new DataMappingRequiredFileException("The @DataMapping#value(%s) is required, but there is no corresponding data file".formatted(key));
            }
        });
        if (config.enforceBean() && !(dataMappingErrors = this.collectDataMappingErrors(annotationMap.keySet(), dataJsonMap.keySet())).isEmpty()) {
            throw new DataMappingMismatchException("Some data mappings and data files do not match: %n%s. Data mapping enforcement may be disabled in Roq.".formatted(String.join((CharSequence)System.lineSeparator(), dataMappingErrors)));
        }
        for (RoqDataBuildItem roqDataBuildItem : roqDataBuildItems) {
            String name = roqDataBuildItem.getName();
            if (annotationMap.containsKey(name)) {
                AnnotationTarget target = ((AnnotationInstance)annotationMap.get(name)).target();
                if (!dataJsonMap.containsKey(name)) continue;
                RoqDataBuildItem item = (RoqDataBuildItem)((Object)dataJsonMap.get(name));
                DotName className = target.asClass().name();
                boolean isParentMapping = ((AnnotationInstance)annotationMap.get(name)).valueWithDefault(index.getIndex(), "parentArray").asBoolean();
                if (isParentMapping) {
                    Optional<MethodInfo> parentMapping = target.asClass().constructors().stream().filter(this::isComplianceWithParentMapping).findAny();
                    MethodInfo methodInfo = parentMapping.orElseThrow(() -> new RuntimeException("@DataMapping(parentArray=true) should declare a single parameter constructor with type List<T>"));
                    DotName type = ((Type)methodInfo.parameterType(0).asParameterizedType().arguments().get(0)).name();
                    dataMappingProducer.produce((BuildItem)new DataMappingBuildItem(name, item.sourceFile(), className, type, item.getContent(), item.converter(), target.asClass().isRecord()));
                    continue;
                }
                DataMappingBuildItem roqMapping = new DataMappingBuildItem(name, item.sourceFile(), null, className, item.getContent(), item.converter(), target.asClass().isRecord());
                dataMappingProducer.produce((BuildItem)roqMapping);
                continue;
            }
            try {
                Object converted = roqDataBuildItem.converter().convert(roqDataBuildItem.getContent());
                dataJsonProducer.produce((BuildItem)new RoqDataJsonBuildItem(name, converted));
            }
            catch (IOException e) {
                throw new DataConversionException("Unable to convert data file %s as an Object".formatted(roqDataBuildItem.sourceFile()), e);
            }
        }
    }

    private boolean isComplianceWithParentMapping(MethodInfo methodInfo) {
        if (methodInfo.parametersCount() == 1) {
            return methodInfo.parameterType(0).asParameterizedType().name().equals((Object)ClassType.create(List.class).name());
        }
        return false;
    }

    private List<String> collectDataMappingErrors(Set<String> annotations, Set<String> data) {
        ArrayList<String> messages = new ArrayList<String>();
        for (String name : annotations) {
            if (data.contains(name)) continue;
            messages.add("The @DataMapping#value('%s') does not match with any data file".formatted(name));
        }
        for (String name : data) {
            if (annotations.contains(name)) continue;
            messages.add("The data file '%s' does not match with any @DataMapping class".formatted(name));
        }
        return messages;
    }

    public Collection<RoqDataBuildItem> scanDataFiles(RoqProjectBuildItem roqProject, DataConverterFinder converter, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFilesProducer, RoqDataConfig config) throws IOException {
        HashMap items = new HashMap();
        Consumer<Path> roqDirConsumer = path -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                try (Stream<Path> pathStream = Files.find(path, Integer.MAX_VALUE, (p, a) -> Files.isRegularFile(p, new LinkOption[0]) && RoqDataReaderProcessor.isExtensionSupported(p), new FileVisitOption[0]);){
                    pathStream.forEach(RoqDataReaderProcessor.addRoqDataBuildItem(converter, watchedFilesProducer, path, items));
                }
                catch (IOException e) {
                    throw new DataScanningException("Error while scanning data files on location: '%s'".formatted(path.toString()), e);
                }
            }
        };
        roqProject.consumePathFromRoqDir(config.dir(), roqDirConsumer);
        roqProject.consumePathFromRoqResourceDir(config.dir(), p -> roqDirConsumer.accept(p.getPath()));
        return items.values();
    }

    private static Consumer<Path> addRoqDataBuildItem(DataConverterFinder converter, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFilesProducer, Path rootDir, Map<String, RoqDataBuildItem> items) {
        return file -> {
            DataConverter dataConverter;
            String name = rootDir.relativize((Path)file).toString().replaceAll("\\..*", "").replaceAll("/", "_");
            if (items.containsKey(name)) {
                throw new DataConflictException("Multiple data files found for the name: '%s'.".formatted(name));
            }
            String filename = file.getFileName().toString();
            if (Path.of("", new String[0]).getFileSystem().equals(file.getFileSystem())) {
                watchedFilesProducer.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(file.toAbsolutePath().toString(), true));
            }
            if ((dataConverter = converter.fromFileName(filename)) != null) {
                try {
                    items.put(name, new RoqDataBuildItem(name, (Path)file, Files.readAllBytes(file), dataConverter));
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Error while reading data file: '%s'".formatted(filename), e);
                }
            }
        };
    }

    private static boolean isExtensionSupported(Path file) {
        String fileName = file.getFileName().toString();
        return SUPPORTED_EXTENSIONS.stream().anyMatch(fileName::endsWith);
    }
}

